import bpy
import os
from bpy.types import Operator, AddonPreferences
from bpy.props import StringProperty, BoolProperty, FloatProperty, EnumProperty

def get_name():
    return os.path.basename(get_path())

def get_path():
    return os.path.dirname(os.path.dirname(os.path.realpath(__file__)))


class ZUV_AddonPreferences(AddonPreferences):

    bl_idname = get_name() #"ZenUV"

    def pack_eng_callback(self, context):
        return (("BLDR", "Blender Pack", "Blender Pack Engine"),
        ("PKM","UVPackmaster 2","UVPackmaster 2 Pack Engine"))

    markSharpEdges: BoolProperty(
        name="Mark Sharp Edges",
        description="Automatically assign Sharp edges",
        default=True,
        )
    
    markSeamEdges: BoolProperty(
        name="Mark Seams",
        description="Automatically assign Seams",
        default=True,
        )

    autoSeamsWithUnwrap: BoolProperty(
        name="Auto Mark with Zen Unwrap",
        description="Automatically Mark edges by angle for Zen Unwrap",
        default=True

        )

    autoPinQuadrified: BoolProperty(
        name="Auto Pin Quadrified",
        description="Automatically Pin Islands after Quadrify Islands operation",
        default=False
        )
    
    packEngine: EnumProperty(
        items=pack_eng_callback,
        name="Pack Engine",
        description="Select Pack Engine for Pack Islands operation",
        default=None
        )

    averageBeforePack: BoolProperty(
        name="Average Islands Scale",
        description="Average Islands scale before Pack Islands operation",
        default=True
        )
    
    autoFitUV: BoolProperty(
        name="Auto Fit UV View",
        description="Automatically Fit and Zoom UV viewport",
        default=True
        )
    
    unwrapConfirm: BoolProperty(
        name="Unwrap Confirm",
        description="Confirm Unwrap for whole object",
        default=False
        )

    sortIslands: BoolProperty(
        name="Islands Offset",
        description="Offset Islands after Zen Unwrap. (Experimental)",
        default=False
        )
    
    margin: FloatProperty(
        name="Margin",
        description="Set space between Islands for Pack Islands operation",
        min=0.0,
        default=0.005,
        precision=3
    )

    workOnSelected: BoolProperty(
        name="Selected Only",
        description="Separate workflow where only Selected Faces will be Unwrapped and Packed. It includes warnings and Unwrapping options if nothing is selected",
        default=False
        )
    
    packAfQuadrify: BoolProperty(
        name="Pack After Quadrify",
        description="Automatically Pack Islands after Quadrify Islands operation",
        default=False
        )


    # def draw(self, context):
    #     layout = self.layout
    #     layout.label(text="This is a preferences view for our add-on")
    #     layout.prop(self, "markSharpEdges")
    #     layout.prop(self, "markSeamEdges")
    #     layout.prop(self, "autoSeamsWithUnwrap")
    #     layout.prop(self, "autoPinQuadrified")
    #     layout.prop(self, "packEngine")
    #     layout.prop(self, "averageBeforePack")


