import bpy

from bpy.utils import register_class, unregister_class

from . import main_pie_v_01, main_panel, main_popup_ext, pref_popup, main_panel_ext
from . import ui_call
from . import callers
from . import pin_menu
from . import zen_unwrap_popup
from . import zen_pack_popup

panel_ext = (
    main_panel_ext.ZUV_PT_Controls,
    main_panel_ext.ZUV_PT_Operators,
    main_panel_ext.ZUV_PT_Preferences,
    main_panel_ext.ZUV_OT_resetPreferences,
    main_panel_ext.ZUV_PT_Help
)

panel = (
    main_panel.ZUV_PT_Controls,
    main_panel.ZUV_PT_Operators,
    main_panel.ZUV_PT_Prefs,
    main_panel.ZUV_PT_Help
)

classes = (
    main_pie_v_01.ZUV_MT_Main_Pie,
    main_popup_ext.ZenUV_MT_Main_Popup,
    pref_popup.ZenUV_MT_Preferences_Popup,
    ui_call.ZUV_OT_Main_Pie_call,
    ui_call.ZUV_OT_Main_Popup_call,
    ui_call.ZUV_OT_Pref_Popup_call,
    callers.ZUV_OT_Caller_Sector_9,
    callers.ZUV_OT_Caller_Sector_4,
    callers.ZUV_OT_Caller_Sector_7,
    callers.ZUV_OT_Caller_Sector_3,
    callers.ZUV_OT_Caller_Sector_6,
    callers.ZUV_OT_Caller_Sector_8,
    callers.ZUV_OT_Caller_Sector_2,
    zen_unwrap_popup.ZenUV_MT_ZenUnwrap_Popup,     
    zen_pack_popup.ZenUV_MT_ZenPack_Popup

)


# handle the keymap
addon_keymaps = []

def register():
    
    for cls in panel_ext:
        register_class(cls)

    for cls in classes:
        register_class(cls)
    
    wm = bpy.context.window_manager
    kc = wm.keyconfigs.addon
    if not kc:
        print('Zen UV Keymap Error')
        return

    

    # add keymap entry
    km = wm.keyconfigs.addon.keymaps.new(name='Mesh', space_type='EMPTY')

    # Register keymap for 
    kmi = km.keymap_items.new(
        ui_call.ZUV_OT_Main_Pie_call.bl_idname, 'U', 'PRESS', ctrl=False, shift=False, alt=True)
    addon_keymaps.append((km, kmi))

    # hotkey for popup in Edit mesh mode

    kmi = km.keymap_items.new(
        ui_call.ZUV_OT_Main_Popup_call.bl_idname, 'U', 'PRESS', ctrl=False, shift=True, alt=False)
    addon_keymaps.append((km, kmi))

    # add keymap entry
    km = wm.keyconfigs.addon.keymaps.new(name='UV Editor', space_type='EMPTY')

    # Register keymap for 
    kmi = km.keymap_items.new(
        ui_call.ZUV_OT_Main_Pie_call.bl_idname, 'U', 'PRESS', ctrl=False, shift=False, alt=True)
    addon_keymaps.append((km, kmi))
    # hotkey for popup in uv editor
    kmi = km.keymap_items.new(
        ui_call.ZUV_OT_Main_Popup_call.bl_idname, 'U', 'PRESS', ctrl=False, shift=True, alt=False)
    addon_keymaps.append((km, kmi))

def unregister():
    
    
    for cls in panel_ext:
        unregister_class(cls)

    for cls in classes:
        unregister_class(cls)
        
    for km, kmi in addon_keymaps:
        km.keymap_items.remove(kmi)

    addon_keymaps.clear()