import bpy
import bmesh

from ..utils.messages import zen_message

def get_mesh_data():
    "Return me as obj.data and bm as bmesh.from_edit_mesh(me)"
    obj = bpy.context.edit_object
    return obj.data, bmesh.from_edit_mesh(obj.data)
    
def check_selection():
    me, bm = get_mesh_data()
    return len([f for f in bm.faces if f.select]) > 0 or len([e for e in bm.edges if e.select]) > 0


class ZUV_OT_Caller_Sector_9(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_9"
    bl_label = "Zen UV Caller Sector 9"
    bl_description = """Setup Auto Seams.
ALT — Setup Seams by UV borders"""
    bl_options = {'REGISTER', 'UNDO'}

    option = "direct"

    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        if event.alt and event.type == "LEFTMOUSE":
            self.option = 'alt'
        else:
            pass
        return self.execute(context)

    def execute(self, context):
        if self.option == "direct":
            bpy.ops.uv.zenuv_auto_seams('INVOKE_DEFAULT')
            # bpy.ops.screen.redo_last('INVOKE_DEFAULT')
        elif self.option == "alt":
            bpy.ops.uv.zenuv_seams_by_uv_islands()
        return {'FINISHED'}


class ZUV_OT_Caller_Sector_4(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_4"
    bl_label = "Zen UV Caller Sector 4"
    bl_description = """Unmark selected edges or face borders as Seams and/or Sharp edges.
CTRL — Unpin Islands. Select at least one edge/face of the Island(s).
ALT — Unmark All. Remove all the Seams and/or Sharp edges from the mesh"""

    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        # If Alt pressed - do Full clear Seams
        if event.alt and event.type == "LEFTMOUSE":
            bpy.ops.uv.zenuv_full_clear_seams()
        # If Ctrl pressed - do Pin Island
        elif event.ctrl and event.type == "LEFTMOUSE":
            if bpy.ops.uv.zenuv_pin_island.poll():
                bpy.ops.uv.zenuv_pin_island(pin_action=False)
        # If no key modifiers pressed - do Unmark Seams
        else:
            if bpy.ops.uv.zenuv_unmark_seams.poll():
                bpy.ops.uv.zenuv_unmark_seams()
        return self.execute(context)

    def execute(self, context):
        return {'FINISHED'}


class ZUV_OT_Caller_Sector_7(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_7"
    bl_label = "Zen UV Caller Sector 7"
    bl_description = """Select UV Island. Select at least one edge/face of the Island(s).
ALT — Select Overlapped Islands."""
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        # print(event.alt, event.type, event.value)
        if event.alt and event.type == "LEFTMOUSE":
            if bpy.ops.uv.zenuv_select_uv_overlap.poll():
                bpy.ops.uv.zenuv_select_uv_overlap()
        else:
            if bpy.ops.uv.zenuv_select_island.poll():
                bpy.ops.uv.zenuv_select_island()
            
        return self.execute(context)

    def execute(self, context):
        return {'FINISHED'}


class ZUV_OT_Caller_Sector_3(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_3"
    bl_label = "Zen UV Caller Sector 3"
    bl_description = """Add Checker Texture to the mesh (Toggle).
CTRL — Show Pinned Islands (Toggle)"""
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        # if Ctrl pressed - do Toggle show Pinned Islands
        if event.ctrl and event.type == "LEFTMOUSE":
            bpy.ops.uv.zenuv_toggle_color_to_pinned_islands()
        # if no key modifiers pressed - do Toggle UV Checker texture
        else:
            bpy.ops.uv.zenuv_toggle_checker_texture()
            
        return self.execute(context)

    def execute(self, context):
        return {'FINISHED'}


class ZUV_OT_Caller_Sector_6(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_6"
    bl_label = "Zen UV Caller Sector 6"
    bl_description = """Mark selected edges or face borders as Seams and/or Sharp edges.
CTRL — Pin Islands. Select at least one edge/face of the Island(s)"""

    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        # If Alt pressed - do Full clear Seams
        # if event.alt:
        #     bpy.ops.uv.zenuv_full_clear_seams()
        # If Ctrl pressed - do Pin Island
        if event.ctrl and event.type == "LEFTMOUSE":
            if bpy.ops.uv.zenuv_pin_island.poll():
                bpy.ops.uv.zenuv_pin_island(pin_action=True)
        # If no key modifiers pressed - do Mark Seams
        else:
            if bpy.ops.uv.zenuv_mark_seams.poll():
                bpy.ops.uv.zenuv_mark_seams()
        return self.execute(context)

    def execute(self, context):
        return {'FINISHED'}


class ZUV_OT_Caller_Sector_8(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_8"
    bl_label = "Zen UV Caller Sector 8"
    bl_description = """Isolate Island (Toggle). Select at least one edge/face of the Island(s)"""
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        # if Alt pressed - do Zen Pack UV
        if event.alt and event.type == "LEFTMOUSE":
            pass
            # bpy.ops.uv.zenuv_pack()
        # if no key modifiers pressed - do Isolate Island
        else:
            if bpy.ops.uv.zenuv_isolate_island.poll():
                bpy.ops.uv.zenuv_isolate_island()
            else:
                zen_message(message="Nothing is made. Try to select something.")
            
        return self.execute(context)

    def execute(self, context):
        return {'FINISHED'}


class ZUV_OT_Caller_Sector_2(bpy.types.Operator):
    bl_idname = "zenuv.caller_sector_2"
    bl_label = "Zen UV Caller Sector 2"
    bl_description = """Unwrap by Marked edges and Pack after. 
Also, you can select edges/faces and do Zen Unwrap. 
All selected edges/faces will be Marked as Seams and/or Sharp edges and unwrapped after.
ALT — Pack UV Islands"""
    bl_options = {'REGISTER', 'UNDO'}


    @classmethod
    def poll(cls, context):
        return True
    
    def invoke(self, context, event):
        # if Alt pressed - do Zen Pack UV
        if event.alt and event.type == "LEFTMOUSE":
            bpy.ops.uv.zenuv_pack()
        # if no key modifiers pressed - do Isolate Island
        else:
            bpy.ops.uv.zenuv_unwrap('INVOKE_DEFAULT')
            
        return self.execute(context)

    def execute(self, context):
        return {'FINISHED'}