import bpy
from ..ico import icon_get

class ZUV_PT_Controls(bpy.types.Panel):
    bl_idname = "ZUV_PT_Controls"
    bl_label = "Controls"
    bl_category = 'Zen UV'
    bl_context = "mesh_edit"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'

    def draw(self, context):
        layout = self.layout
        # layout.label(text="Zen Controls")
        # pie = layout.menu_pie().column()
        layout.operator("zenuv.call_pie", text="Zen UV Pie", icon_value=icon_get("zen-uv_32"))
        layout.operator("zenuv.call_popup", text="Zen UV Menu" )


class ZUV_PT_Operators(bpy.types.Panel):
    bl_idname = "ZUV_PT_ZenUV"
    bl_label = "Operators"
    bl_category = "Zen UV"
    bl_context = "mesh_edit"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"

    def draw(self, context):
        layout = self.layout
        # scene = context.scene
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        # area_type = bpy.context.area.type

        layout.operator("uv.zenuv_unwrap", icon_value=icon_get("zen-unwrap_32"))

        layout.separator()

        col = layout.column()

        col.operator("uv.zenuv_auto_seams")

        row = col.row()
        row.operator("uv.zenuv_mark_seams", text='Mark', icon_value=icon_get("mark-seams_32"))
        row.operator("uv.zenuv_unmark_seams", text='Unmark', icon_value=icon_get("unmark-seams_32"))

        col.operator("uv.zenuv_seams_by_uv_islands")
        col.operator("uv.zenuv_seams_by_sharp")
        col.operator("uv.zenuv_sharp_by_seams")
        col.operator("uv.zenuv_full_clear_seams")

        col.separator()
        col.prop(addon_prefs, 'averageBeforePack')

        col.operator("uv.zenuv_pack")

        layout.separator()

        col = layout.column()
        col.operator("uv.zenuv_select_island")
        col.operator("uv.zenuv_isolate_island")
        col.operator("uv.zenuv_quadrify")
        col.operator("uv.zenuv_select_uv_overlap")
        col.operator("ops.zenuv_select_loop")

        layout.separator()

        col = layout.column()
        row = col.row()
        row.operator("uv.zenuv_pin_island", text="Pin UV Island").pin_action = True
        row.operator("uv.zenuv_pin_island", text="Unpin UV Island").pin_action = False
        col.operator("uv.zenuv_toggle_color_to_pinned_islands")

        layout.separator()
    
        layout.operator("uv.zenuv_toggle_checker_texture")
        layout.operator("view3d.zenuv_set_autosmooth")



class ZUV_PT_Prefs(bpy.types.Panel):
    bl_idname = "ZUV_PT_Setup"
    bl_label = "Preferences"
    bl_category = "Zen UV"
    bl_context = "mesh_edit"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"

    def draw(self, context):
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        layout = self.layout
        area_type = bpy.context.area.type

        layout.prop(addon_prefs, 'autoSeamsWithUnwrap')
        layout.prop(addon_prefs, 'markSeamEdges')
        layout.prop(addon_prefs, 'markSharpEdges')
        layout.prop(addon_prefs, 'autoPinQuadrified')
        layout.prop(addon_prefs, 'autoFitUV')
        layout.prop(addon_prefs, 'sortIslands')
        layout.prop(addon_prefs, 'margin')
        layout.prop(addon_prefs, "packEngine")
        layout.prop(addon_prefs, "workOnSelected")

        if area_type == 'VIEW_3D':
            layout.prop(context.space_data.overlay, "show_edge_seams", text='Show Seams Edges')
            layout.prop(context.space_data.overlay, "show_edge_sharp", text='Show Sharp Edges')
            


class ZUV_PT_Help(bpy.types.Panel):
    bl_idname = "ZUV_PT_Help"
    bl_label = "Help / Links"
    bl_category = "Zen UV"
    bl_context = "mesh_edit"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"

    def draw(self, context):
        layout = self.layout
        layout.operator("wm.url_open", text="Documentation", icon="HELP").url="https://zen-masters.github.io/Zen-UV/"
        layout.operator("wm.url_open", text="Discord", icon_value=icon_get("Discord-Logo-White_32")).url="https://discordapp.com/invite/wGpFeME"


