import bpy
import os
from ..ico import icon_get

class ZUV_PT_Generic(bpy.types.Panel):

    def draw(self, context):
        # self.prefs = get_prefs()
        # self.scene_props = context.scene.uvp2_props
     
        self.draw_specific(context)


class ZUV_PT_ControlsBase(ZUV_PT_Generic):
    bl_idname = 'ZUV_PT_ControlsBase'
    bl_label = 'Controls'
    bl_context = ""


    """def draw_header(self, _):
        layout = self.layout
        layout.label(text="",  icon_value=icon_get("zen-uv_32"))"""

    def draw_specific(self, context):
        layout = self.layout
        col = layout.column(align=True)
        col.separator()
        row = col.row(align=True)

        row.operator("zenuv.call_pie", text="Zen UV Pie Menu", icon_value=icon_get("zen-uv_32"))
        col.operator("zenuv.call_popup", text="Zen UV Popup Menu" )


class ZUV_PT_HelpBase(ZUV_PT_Generic):
    bl_label = 'Help'
    bl_context = ""
    bl_options = {'DEFAULT_CLOSED'}

    def draw_specific(self, context):
        layout = self.layout
        if not context.active_object.mode == 'EDIT':
            layout.label(text='To use Zen UV enter Edit mode.')
        col = layout.column(align=True)

        row = col.row(align=True)
        row.operator("wm.url_open", text="Documentation", icon="HELP").url="https://zen-masters.github.io/Zen-UV/"
        row = col.row(align=True)
        row.operator("wm.url_open", text="Discord", icon_value=icon_get("Discord-Logo-White_32")).url="https://discordapp.com/invite/wGpFeME"



class ZUV_PT_OperatorsBase(ZUV_PT_Generic):
    bl_label = 'Operators'
    bl_context = ""

    def draw_specific(self, context):
        addon_prefs = context.preferences.addons[os.path.basename(os.path.dirname(os.path.dirname(os.path.realpath(__file__))))].preferences

        layout = self.layout
        

        # Zen Unwrap Section
        col = layout.column(align=True)
        col.operator("uv.zenuv_unwrap", icon_value=icon_get("zen-unwrap_32"))
        box = col.box()
        row = box.row()
        row.prop(addon_prefs, 'autoSeamsWithUnwrap')
        row = box.row()
        row.prop(addon_prefs, "workOnSelected")
        if addon_prefs.workOnSelected:
            row = box.row()
            row.prop(addon_prefs, 'sortIslands')


        # Seams Section

        col = layout.column(align=True)

        col.operator("uv.zenuv_auto_seams")
        row = col.row(align=True)
        row.operator("uv.zenuv_mark_seams", icon_value=icon_get("mark-seams_32"))
        row.operator("uv.zenuv_unmark_seams", icon_value=icon_get("unmark-seams_32"))
        col.operator("uv.zenuv_full_clear_seams")
        box = col.box()
        row = box.row()
        row.prop(addon_prefs, 'markSeamEdges')
        row = box.row()
        row.prop(addon_prefs, 'markSharpEdges')

        # Seam By Section

        col = layout.column(align=True)
        col.operator("uv.zenuv_seams_by_uv_islands")
        col.operator("uv.zenuv_seams_by_sharp")
        col.operator("uv.zenuv_sharp_by_seams")

        # Quadrify Section

        col = layout.column(align=True)
        col.operator("uv.zenuv_quadrify")
        box = col.box()
        row = box.row(align=True)
        row.prop(addon_prefs, 'autoPinQuadrified')
        row = box.row(align=True)
        row.prop(addon_prefs, 'packAfQuadrify')

        
        # Pack Section

        col = layout.column(align=True)
        col.operator("uv.zenuv_pack")
        col.prop(addon_prefs, 'margin')
        box = col.box()
        row = box.row(align=True)
        row.prop(addon_prefs, 'averageBeforePack')
        row = box.row(align=True)
        row.label(text="Pack Engine:")
        
        # row = box.row(align=True)
        col.prop(addon_prefs, "packEngine", text="")
        
        # Select Section

        col = layout.column(align=True)
        col.operator("uv.zenuv_select_island", text="Select Islands")
        col.operator("uv.zenuv_isolate_island")
        col.operator("uv.zenuv_select_uv_overlap")
        col.operator("ops.zenuv_select_loop")

        # Pin Section

        col = layout.column(align=True)
        row = col.row(align=True)
        row.operator("uv.zenuv_pin_island", text="Pin Islands").pin_action = True
        row.operator("uv.zenuv_pin_island", text="Unpin Islands").pin_action = False
        col.operator("uv.zenuv_toggle_color_to_pinned_islands")

        # Togglers Section

        col = layout.column(align=True)
        col.operator("uv.zenuv_toggle_checker_texture")
        col.operator("view3d.zenuv_set_autosmooth")


class ZUV_PT_PreferencesBase(ZUV_PT_Generic):
    bl_label = 'Preferences'
    bl_context = ""

    def draw_specific(self, context):
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        layout = self.layout
        area_type = bpy.context.area.type

        col = layout.column(align=True)
        box = col.box()
        row = box.row(align=True)
        row.prop(addon_prefs, 'autoFitUV')

        if area_type == 'VIEW_3D':
            row = box.row(align=True)
            row.prop(context.space_data.overlay, "show_edge_seams", text='Show Seams',  text_ctxt="Test", translate=True)
            row = box.row(align=True)
            row.prop(context.space_data.overlay, "show_edge_sharp", text='Show Sharp Edges')
            row = box.row(align=True)
            row.prop(context.space_data.overlay, "show_edge_bevel_weight", text='Show Bevel Weights')
            row = box.row(align=True)
            row.prop(context.space_data.overlay, "show_edge_crease", text='Show Crease Edges')
        # row = col.row(align=True)
        layout.operator("zenuv.reset_preferences")

class ZUV_OT_resetPreferences(bpy.types.Operator):
    """ Reset Zen UV Preferences """
    bl_idname = "zenuv.reset_preferences"
    bl_label = "Reset Preferences"
    bl_description = "Reset preferences to Default state"
    bl_options = {"INTERNAL"}

    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self)

    def draw(self, context):
        layout = self.layout
        layout.label(text="Confirm: Reset Zen UV preferences to Default state?")
        layout.separator()

    def execute(self, context):
        
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        items = addon_prefs.__annotations__.keys()
        for pref in items:
            addon_prefs.property_unset(pref)

        return {'FINISHED'}
