import bpy
from bpy.types import Menu
from ..ico import icon_get

bl_info = {
    "name": "Zen UV Pie Menu",
    "version": (0, 1),
    "description": "Zen UV Main Pie Menu",
    "blender": (2, 80, 0),
    "category": "UV"
}

def operator_text(context, input_text):
    addon_prefs = context.preferences.addons["ZenUV"].preferences
    if addon_prefs.markSeamEdges:
        input_text += ' Seams'
        if addon_prefs.markSharpEdges:
            input_text += ' /'
    if addon_prefs.markSharpEdges:
        input_text += ' Sharp Edges'
    return input_text

class ZUV_MT_Main_Pie(Menu):
    bl_label = 'Zen UV'
    bl_idname = "ZUV_MT_Main_Pie"

    def draw(self, context):
        layout = self.layout
        pie = layout.menu_pie()

        # Sector 4 ###########################################################
        pie.operator("zenuv.caller_sector_4", text=operator_text(context, input_text="Unmark"), icon_value=icon_get("unmark-seams_32"))


        # Sector 6 ###########################################################
        pie.operator("zenuv.caller_sector_6", text=operator_text(context, input_text="Mark"), icon_value=icon_get("mark-seams_32"))

        # Sector 2 ###########################################################
        pie.operator("zenuv.caller_sector_2", text="Zen Unwrap", icon_value=icon_get("zen-unwrap_32"))
        # pie.operator("uv.zenuv_unwrap", text="Zen Unwrap", icon_value=icon_get("zen-unwrap_32"))

        # Sector 8 ###########################################################
        pie.operator("zenuv.caller_sector_8", text="Isolate Island (Toggle)")


        # Sector 7 ###########################################################
        pie.operator("zenuv.caller_sector_7", text="Select UV Island")

        # Sector 9 ###########################################################
        # pie.operator("zenuv.caller_sector_9", text="Auto Seams")
        pie.operator("uv.zenuv_auto_seams")
        

        # Sector 1 ###########################################################

        pie.operator("uv.zenuv_quadrify", text="Quadrify Island")

        # Sector 3 ###########################################################
        pie.operator("zenuv.caller_sector_3", text="Checker Texture (Toggle)")






