import bpy
from ..ico import icon_get

bl_info = {
    "name": "Zen UV Popup Menu",
    "version": (0, 1),
    "description": "Zen UV Main Popup Menu",
    "blender": (2, 80, 0),
    "category": "UV"
}

class ZenUV_MT_Main_Popup(bpy.types.Menu):
    bl_label = "Zen UV Menu"
    bl_idname = "ZUV_MT_Main_Popup_Legacy"

    def draw(self, context):
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        layout = self.layout
        scene = context.scene
        area_type = bpy.context.area.type


        layout.operator("uv.zenuv_unwrap", icon_value=icon_get("zen-unwrap_32"))
        layout.separator()

        layout.operator("uv.zenuv_auto_seams")


        layout.operator("uv.zenuv_mark_seams", icon_value=icon_get("mark-seams_32"))
        layout.operator("uv.zenuv_unmark_seams", icon_value=icon_get("unmark-seams_32"))

        layout.operator("uv.zenuv_seams_by_uv_islands")
        layout.operator("uv.zenuv_seams_by_sharp")
        layout.operator("uv.zenuv_sharp_by_seams")
        layout.operator("uv.zenuv_full_clear_seams")

        layout.separator()
        layout.prop(addon_prefs, 'averageBeforePack')
        layout.operator("uv.zenuv_pack")

        layout.separator()

        layout.operator("uv.zenuv_select_island")
        layout.operator("uv.zenuv_isolate_island")
        layout.operator("uv.zenuv_quadrify")
        layout.operator("uv.zenuv_select_uv_overlap")
        layout.operator("ops.zenuv_select_loop")

        layout.separator()


        layout.operator("uv.zenuv_pin_island", text="Pin UV Island").pin_action = True
        layout.operator("uv.zenuv_pin_island", text="Unpin UV Island").pin_action = False
        layout.operator("uv.zenuv_toggle_color_to_pinned_islands")

        layout.separator()
    
        layout.operator("uv.zenuv_toggle_checker_texture")
        layout.operator("view3d.zenuv_set_autosmooth")

        layout.split()
        layout.separator()
        layout.prop(addon_prefs, 'autoSeamsWithUnwrap', text='Auto Seams With Unwrap')
        layout.prop(addon_prefs, 'markSeamEdges')
        layout.prop(addon_prefs, 'markSharpEdges')
        layout.prop(addon_prefs, 'autoPinQuadrified', text='Auto Pin Quadrified')
        layout.prop(addon_prefs, 'autoFitUV')
        layout.prop(addon_prefs, 'sortIslands')

        layout.separator()

        if area_type == 'VIEW_3D':
            layout.prop(context.space_data.overlay, "show_edge_seams", text='Show Seams Edges')
            layout.prop(context.space_data.overlay, "show_edge_sharp", text='Show Sharp Edges')
            

if __name__ == "__main__":
    pass
