import bpy
from ..ico import icon_get

bl_info = {
    "name": "Zen UV Popup Menu",
    "version": (0, 1),
    "description": "Zen UV Main Popup Menu",
    "blender": (2, 80, 0),
    "category": "UV"
}

class ZenUV_MT_Main_Popup(bpy.types.Menu):
    bl_label = "Zen UV Menu"
    bl_idname = "ZUV_MT_Main_Popup"

    def draw(self, context):
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        layout = self.layout
        area_type = bpy.context.area.type

        # Zen Unwrap Section
        
        layout.operator("uv.zenuv_unwrap", icon_value=icon_get("zen-unwrap_32"))
        layout.prop(addon_prefs, 'autoSeamsWithUnwrap')
        layout.prop(addon_prefs, "workOnSelected")
        if addon_prefs.workOnSelected:
            layout.prop(addon_prefs, 'sortIslands')

        # Seams Section
        layout.separator()

        layout.operator("uv.zenuv_auto_seams", text='Auto Mark')
        layout.operator("uv.zenuv_mark_seams", icon_value=icon_get("mark-seams_32"))
        layout.operator("uv.zenuv_unmark_seams", icon_value=icon_get("unmark-seams_32"))
        layout.operator("uv.zenuv_full_clear_seams")
        layout.prop(addon_prefs, 'markSeamEdges')
        layout.prop(addon_prefs, 'markSharpEdges')

        # Seam By Section
        layout.separator()

        layout.operator("uv.zenuv_seams_by_uv_islands")
        layout.operator("uv.zenuv_seams_by_sharp")
        layout.operator("uv.zenuv_sharp_by_seams")

        # Quadrify Section
        layout.separator()

        layout.operator("uv.zenuv_quadrify")
        layout.prop(addon_prefs, 'autoPinQuadrified')
        layout.prop(addon_prefs, 'packAfQuadrify')

        # Pack Section
        layout.separator()

        layout.operator("uv.zenuv_pack")
        layout.prop(addon_prefs, 'margin')
        layout.prop(addon_prefs, 'averageBeforePack')
        # layout.prop(addon_prefs, "packEngine")
        
        # Select Section
        layout.separator()

        layout.operator("uv.zenuv_select_island", text="Select Islands")
        layout.operator("uv.zenuv_isolate_island")
        layout.operator("uv.zenuv_select_uv_overlap")
        layout.operator("ops.zenuv_select_loop")

        # Pin Section
        layout.separator()

        layout.operator("uv.zenuv_pin_island", text="Pin Islands").pin_action = True
        layout.operator("uv.zenuv_pin_island", text="Unpin Islands").pin_action = False
        layout.operator("uv.zenuv_toggle_color_to_pinned_islands")

        # Togglers Section
        layout.separator()

        layout.operator("uv.zenuv_toggle_checker_texture")
        layout.operator("view3d.zenuv_set_autosmooth")

        # Prefs Section
        layout.separator()

        layout.prop(addon_prefs, 'autoFitUV')

        if area_type == 'VIEW_3D':
            layout.prop(context.space_data.overlay, "show_edge_seams", text='Show Seams')
            layout.prop(context.space_data.overlay, "show_edge_sharp", text='Show Sharp Edges')
            layout.prop(context.space_data.overlay, "show_edge_bevel_weight", text='Show Bevel Weights')
            layout.prop(context.space_data.overlay, "show_edge_crease", text='Show Crease Edges')
            

if __name__ == "__main__":
    pass
