import bpy


class ZenUV_MT_Preferences_Popup(bpy.types.Menu):
    bl_label = "Zen UV Preferences"
    bl_idname = "ZUV_MT_Preferences_Popup"
    bl_icon = "KEYTYPE_EXTREME_VEC"

    def draw(self, context):
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        layout = self.layout
        scene = context.scene
        area_type = bpy.context.area.type

        layout.prop(addon_prefs, 'autoSeamsWithUnwrap')
        layout.prop(addon_prefs, 'markSeamEdges')
        layout.prop(addon_prefs, 'markSharpEdges')
        layout.prop(addon_prefs, 'autoPinQuadrified')

        if area_type == 'VIEW_3D':
            layout.prop(context.space_data.overlay, "show_edge_sharp", text='Show Sharp Edges')
            layout.prop(context.space_data.overlay, "show_edge_seams", text='Show Seams Edges')


if __name__ == "__main__":
    pass

    # # The menu can also be called from scripts
    # bpy.ops.wm.call_menu(name=zenuv_UVSeams_Popup.bl_idname)