import bpy
import bmesh

# from ..operators import operators

class ZUV_OT_Main_Pie_call(bpy.types.Operator):
    bl_idname = 'zenuv.call_pie'
    bl_label = 'Zen UV Pie Menu'
    bl_description = "Call Zen UV Pie menu. You can setup custom hotkey: RMB on the button > Change Shortcut"

    bl_options = {'REGISTER', 'UNDO'}


    def invoke(self, context, event):

        return self.execute(context)

    def execute(self, context):
        obj = bpy.context.edit_object
        mesh = obj.data
        bm = bmesh.from_edit_mesh(mesh)

        selected_faces = [f for f in bm.faces if f.select]
        selected_edges = [e for e in bm.edges if e.select]

        # if selected_faces or selected_edges:
        #     VIEW3D_MT_PIE_Zen_UV.selected_exist = True
        # else:
        #     VIEW3D_MT_PIE_Zen_UV.selected_exist = False

        bpy.ops.wm.call_menu_pie(name="ZUV_MT_Main_Pie")
        return {'FINISHED'}


class ZUV_OT_Main_Popup_call(bpy.types.Operator):
    bl_idname = 'zenuv.call_popup'
    bl_label = 'Zen UV Popup Menu'
    bl_description = "Call Zen UV Popup menu. You can setup custom hotkey: RMB on the button > Change Shortcut"
    bl_options = {'REGISTER', 'UNDO'}

    def invoke(self, context, event):
        return self.execute(context)

    def execute(self, context):
        bpy.ops.wm.call_menu(name="ZUV_MT_Main_Popup")
        return {'FINISHED'}


class ZUV_OT_Pref_Popup_call(bpy.types.Operator):
    bl_idname = 'zenuv.call_prefs'
    bl_label = 'Zen UV Popup Preferences'
    bl_description = 'Call Zen UV Popup Preferences menu'
    bl_options = {'REGISTER', 'UNDO'}

    def invoke(self, context, event):
        return self.execute(context)

    def execute(self, context):
        bpy.ops.wm.call_menu(name="ZUV_MT_Preferences_Popup")
        return {'FINISHED'}