import bpy


class ZenUV_MT_ZenPack_Popup(bpy.types.Menu):
    bl_label = "Zen Unwrap"
    bl_idname = "ZUV_MT_ZenPack_Popup"
    bl_icon = "KEYTYPE_EXTREME_VEC"

    def draw(self, context):
        layout = self.layout
        addon_prefs = context.preferences.addons["ZenUV"].preferences
        layout.label(text="Nothing is produced.")
        layout.label(text="It looks like UVPackmaster 2 addon")
        layout.label(text="is not installed on your system.")
        layout.separator()

        layout.operator("wm.url_open", text="Buy UVPackmaster 2 addon", icon="HELP").url="https://gumroad.com/l/uvpackmaster2"
        
        layout.separator()
        row = layout.row(align=True)
        row.label(text="Or you can change Pack Engine:")
        row = layout.row(align=True)
        layout.prop(addon_prefs, "packEngine", text="")

if __name__ == "__main__":
    pass