import bpy

mat_name = "ZenUV_Checker"
zen_texture_node_name = "ZenUV_Texture_node"
zen_image_name = "ZenUV_Texture"


def switch_shading_style(style, switch):
    for area in bpy.context.screen.areas:
        if area.type == 'VIEW_3D':
            for space in area.spaces:
                if space.type == 'VIEW_3D':
                    if space.shading.color_type == "VERTEX" and style == "VERTEX" and switch:
                        style = "MATERIAL"
                    space.shading.color_type = style
                    # print('Shading is set to VERTEX')
                    return True
    return False


def create_uv_material(obj, mat):
    def get_img_reference(suffix):
        images = bpy.data.images
        for img in images:
            if suffix in img.name:
                return img

    def get_node_reference(nodes, suffix):
        for node in nodes:
            if suffix in node.name:
                return node

    def create_image_node(nodes_collection, node_name):
        node = nodes_collection.new(type='ShaderNodeTexImage')
        node.name = node_name
        return node

    #    print('Creating New Material...\nCreating UV Check texture in NEW material...')

    # Create material
    if not mat:
        mat = (bpy.data.materials.get(mat_name) or
               bpy.data.materials.new(mat_name))

    # Enable 'Use nodes'
    mat.use_nodes = True
    nodes = mat.node_tree.nodes

    # UV SamplerImage Creation
    zen_uv_image = bpy.data.images.get(zen_image_name)

    if not zen_uv_image:
        # print('CreateNewTexture:', zen_uv_image)
        bpy.ops.image.new(name=zen_image_name,
                        width=1024,
                        height=1024,
                        alpha=False,
                        generated_type='UV_GRID',
                        float=False,
                        use_stereo_3d=False
                        )

    # Texture Node creation
    uv_texture_node = (nodes.get(zen_texture_node_name) or
                       create_image_node(nodes, zen_texture_node_name))

    # Set image reference to image node
    zen_uv_image = get_img_reference(zen_image_name)
    if zen_uv_image:
        uv_texture_node.image = zen_uv_image

    # Set all to current object
    obj.active_material = mat


def create_uv_check_texture_in_user_material(obj, mat):
    # print('Creating UV Check texture in user material...')
    create_uv_material(obj, mat)


def switch_checker(obj):
    # print("\nNodes creation switch START ----------------------\n")
    # obj = bpy.context.edit_object

    # If current object have any material, need to create UV image node in first of materials.
    materials_of_object = [m.material for m in obj.material_slots]

    if materials_of_object:
        # print('Mats exist')

        # it's process need to work as a switcher. So first i try to find my uv Cheker node in existing materials.
        mats_with_checker = []
        for mat in materials_of_object:

            # print("\n\nMat_Name: ", mat.name)

            if mat.use_nodes:
                # nodes = mat.node_tree.nodes
                checker_node = mat.node_tree.nodes.get(zen_texture_node_name)
                if checker_node:
                    # print("Checker node exist: Append to list.")
                    mats_with_checker.append([mat, checker_node])

        # Check if founded mats with checker - remove it

        if mats_with_checker:
            for mat in mats_with_checker:
                # print("CheckersAndMats:", mat)
                nodes = mat[0].node_tree.nodes
                if zen_image_name in bpy.data.images.keys():
                    # print("Image In Scene: Remove it.")
                    bpy.data.images.remove(bpy.data.images[zen_image_name])
                    nodes.remove(mat[1])
                    switch_shading_style("MATERIAL", switch=False)
                    return False

        # If NOT - create it in first user material
        else:
            # print("Checker node NOT exist: Create it.")
            create_uv_material(obj, materials_of_object[0])

        switch_shading_style("TEXTURE", switch=False)
        return True
    else:
        # if mat=None - create_uv_material will create mew material and assign it to current object
        create_uv_material(obj, mat=None)
        switch_shading_style("TEXTURE", switch=False)
    
    return True


if __name__ == '__main__':
    pass