import bpy


def get_islands(bm, selected_faces):
    selected_faces[0].select = True
    bpy.ops.uv.select_linked()

    faces_of_island = [f for f in bm.faces if f.select]

    for f in faces_of_island:
        if f in selected_faces:
            selected_faces.remove(f)

    return selected_faces, faces_of_island


def get_island(bm):
    blender_uv_sync_mode = bpy.context.scene.tool_settings.use_uv_select_sync
    bpy.context.scene.tool_settings.use_uv_select_sync = True

    # If no UV map - create it.
    if not bm.loops.layers.uv: bm.loops.layers.uv.new()

    islands = []
    selected_faces = []

    # Check if blender in FACE selection mode
    if bpy.context.tool_settings.mesh_select_mode[2]:
        # print('FACE Selection mode')
        selected_faces = [f for f in bm.faces if f.select]

    # Check if blender in EDGE selection mode
    if bpy.context.tool_settings.mesh_select_mode[1]:
        # print('EDGE Selection mode')
        selected_edges = [e for e in bm.edges if e.select]
        if selected_edges:
            for e in selected_edges:
                selected_faces.extend([face for face in e.link_faces if not face.hide])

    bpy.context.tool_settings.mesh_select_mode = [False, False, True]

    while selected_faces:
        bpy.ops.mesh.select_all(action='DESELECT')
        selected_faces, island = get_islands(bm, selected_faces)
        islands.append(island)
    bpy.context.scene.tool_settings.use_uv_select_sync = blender_uv_sync_mode
    return islands


if __name__ == '__main__':
    pass