import bpy
import bmesh
import random
from mathutils import Color

def set_color_layer(me):
    z_vc_name = "zen_uv_pinned"

    bm = bmesh.from_edit_mesh(me)
    if not bm.loops.layers.color.get(z_vc_name):
        color_layer = bm.loops.layers.color.new(z_vc_name)
    else:
        color_layer = bm.loops.layers.color.get(z_vc_name)
    # set_v_color(me, color_layer, faces)
    return color_layer


def set_v_color(me, color_layer, faces, color, randomize):
    bm = bmesh.from_edit_mesh(me)
    # if color != [255, 255, 255]:
    # color = get_random_color()
    color = color[0], color[1], color[2], 1
    if randomize:
        color = hue_shift(color)


    for face in faces:
        for loop in face.loops:
            loop[color_layer] = color
        # if face.select:
        #     print(face, '- Selected')
        #     for loop in face.loops:
        #         loop[color_layer] = color
    return color


def hue_shift(color):
    color_h = Color()
    color_h.r = color[0]
    color_h.g = color[1]
    color_h.b = color[2]
    color_h.h = random.random()
    return [color_h.r, color_h.g, color_h.b, 1]


def update_vcolor(me):
    bm = bmesh.from_edit_mesh(me)
    if bm.is_wrapped:
        bmesh.update_edit_mesh(me, False, False)
        bpy.ops.object.mode_set(mode='VERTEX_PAINT')
        bpy.ops.object.mode_set(mode="EDIT")
    else:
        bm.to_mesh(me)
        me.update()


def get_random_color(color):
    """generate rgb using a list comprehension"""
    r, g, b = [random.random() for i in range(3)]
    return r, g, b, 1


if __name__ == '__main__':
    pass
