PrefabFiles = {
	"sdabigail",
	"sdabigail_none",
	"sdpan_flute",
	"galaxysword",
	"sdquartz",
	"sdquartzbar",
	"sdiridium",
	"sdiridiumbar",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/sdabigail.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/sdabigail.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/sdabigail.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/sdabigail.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/sdabigail_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/sdabigail_silho.xml" ),

    Asset( "IMAGE", "bigportraits/sdabigail.tex" ),
    Asset( "ATLAS", "bigportraits/sdabigail.xml" ),
	
	Asset( "IMAGE", "images/map_icons/sdabigail.tex" ),
	Asset( "ATLAS", "images/map_icons/sdabigail.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_sdabigail.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_sdabigail.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_sdabigail.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_sdabigail.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_sdabigail.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_sdabigail.xml" ),
	
	Asset( "IMAGE", "images/names_sdabigail.tex" ),
    Asset( "ATLAS", "images/names_sdabigail.xml" ),
	
    Asset( "IMAGE", "bigportraits/sdabigail_none.tex" ),
    Asset( "ATLAS", "bigportraits/sdabigail_none.xml" ),
	
	Asset( "ATLAS", "images/hud/sdabigailtab.xml" ),
	Asset( "IMAGE", "images/hud/sdabigailtab.tex" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH

-- The character select screen lines
STRINGS.CHARACTER_TITLES.sdabigail = "The Elite Egg Hunter"
STRINGS.CHARACTER_NAMES.sdabigail = "Abigail"
STRINGS.CHARACTER_DESCRIPTIONS.sdabigail = "*Carries the Galaxy Sword\n*Loves playing Music\n*Eats Quartz(And a lot of other weird stuff)"
STRINGS.CHARACTER_QUOTES.sdabigail = "\"I made these two drawings. What do you think?\""

-- Custom speech strings
STRINGS.CHARACTERS.SDABIGAIL = require "speech_sdabigail"

-- The character's name as appears in-game 
STRINGS.NAMES.SDABIGAIL = "Abigail"

AddMinimapAtlas("images/map_icons/sdabigail.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("sdabigail", "FEMALE")

--Abigail's Tab

local sdabigailtab = AddRecipeTab( "SDAbigail's Tab", 996, "images/hud/sdabigailtab.xml", "sdabigailtab.tex", "sdabigail_builder")

AddRecipe("sdpan_flute", 
{GLOBAL.Ingredient("papyrus", 1), GLOBAL.Ingredient("nightmarefuel", 1), GLOBAL.Ingredient("rope", 1)}, 
sdabigailtab, TECH.NONE, nil, nil, nil, nil, "sdabigail_builder", 
"images/inventoryimages/sdpan_flute.xml", "sdpan_flute.tex" )

AddRecipe("sdquartzbar", 
{GLOBAL.Ingredient("sdquartz", 10, "images/inventoryimages/sdquartz.xml")}, 
sdabigailtab, TECH.NONE, nil, nil, nil, nil, "sdabigail_builder", 
"images/inventoryimages/sdquartzbar.xml", "sdquartzbar.tex" )

AddRecipe("sdiridiumbar", 
{GLOBAL.Ingredient("sdiridium", 5, "images/inventoryimages/sdiridium.xml")}, 
sdabigailtab, TECH.NONE, nil, nil, nil, nil, "sdabigail_builder", 
"images/inventoryimages/sdiridiumbar.xml", "sdiridiumbar.tex" )

AddRecipe("galaxysword", 
{GLOBAL.Ingredient("sdquartzbar", 5, "images/inventoryimages/sdquartzbar.xml"), GLOBAL.Ingredient("sdiridiumbar", 3, "images/inventoryimages/sdiridiumbar.xml"), GLOBAL.Ingredient("purplegem", 1)}, 
sdabigailtab, TECH.NONE, nil, nil, nil, nil, "sdabigail_builder", 
"images/inventoryimages/galaxysword.xml", "galaxysword.tex" )

-- Custom Recipe Desc
STRINGS.RECIPE_DESC.SDPAN_FLUTE = "A lovely instrument!" 

STRINGS.RECIPE_DESC.SDQUARTZBAR = "A more pure form of quartz." 

STRINGS.RECIPE_DESC.SDIRIDIUMBAR = "A bar of pure iridium!" 

STRINGS.RECIPE_DESC.GALAXYSWORD = "It's unlike anything you've ever seen!" 

AddSimPostInit(function()

local _LT = GLOBAL.LootTables

table.insert(_LT['full_rock'], {"sdquartz", 0.75})
table.insert(_LT['stalagmite_tall_full_rock'], {"sdquartz", 0.75})

table.insert(_LT['full_rock'], {"sdiridium", 0.25})
table.insert(_LT['stalagmite_tall_full_rock'], {"sdiridium", 0.25})

table.insert(_LT['rock1'], {"sdquartz", 0.75})
table.insert(_LT['rock2'], {"sdquartz", 0.75})

table.insert(_LT['rock1'], {"sdiridium", 0.25})
table.insert(_LT['rock2'], {"sdiridium", 0.25})

table.insert(_LT['rock_flintless'], {"sdquartz", 0.75})
table.insert(_LT['rock_flintless_med'], {"sdquartz", 0.75})

table.insert(_LT['rock_flintless'], {"sdiridium", 0.25})
table.insert(_LT['rock_flintless_med'], {"sdiridium", 0.25})

table.insert(_LT['rock_flintless_low'], {"sdquartz", 0.75})
table.insert(_LT['rock_moon'], {"sdquartz", 0.75})

table.insert(_LT['rock_flintless_low'], {"sdiridium", 0.25})
table.insert(_LT['rock_moon'], {"sdiridium", 0.25})

end)