local assets=
{
    Asset("ANIM", "anim/galaxysword.zip"),
    Asset("ANIM", "anim/swap_galaxysword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/galaxysword.xml"),
    Asset("IMAGE", "images/inventoryimages/galaxysword.tex"),
}

local prefabs = 
{

}

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_galaxysword", "swap_galaxysword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
 
 local function onattack(weapon, attacker, target)
    -- if target ~= nil and target.components.burnable ~= nil and math.random() < TUNING.TORCH_ATTACK_IGNITE_PERCENT * target.components.burnable.flammability then
        -- target.components.burnable:Ignite(nil, attacker)
    -- end
	
    local atkfx = SpawnPrefab("explode_small")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
    end
end

local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("galaxysword")
    inst.AnimState:SetBuild("galaxysword")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(70)
    inst.components.weapon:SetOnAttack(onattack)
	  
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "galaxysword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/galaxysword.xml"
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	     
    return inst
end

STRINGS.NAMES.GALAXYSWORD = "Galaxy Sword"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GALAXYSWORD = "Prismatic alignment!"

return  Prefab("common/inventory/galaxysword", fn, assets, prefabs) 