
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"sdpan_flute",
	"pumpkin",
	"spear",
	"pumpkin_seeds", 
	"pumpkin_seeds", 
	"pumpkin_seeds", 
	"pumpkin_seeds",
	"pumpkin_seeds", 
	"pumpkin_seeds", 
	"pumpkin_seeds", 
	"pumpkin_seeds", 
	"pumpkin_seeds", 
	"pumpkin_seeds", 
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "sdabigail_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "sdabigail_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "sdabigail.tex" )
	inst:AddTag("sdabigail_builder")
end

local function oneat1(inst, food)
    if food and food.prefab == "sdquartz" then
	inst.components.talker:Say("Delish!")
	end
end

local function setCanEatQuartz(inst)
    local self = inst.components.eater
  
    table.insert(self.preferseating, FOODTYPE.ELEMENTAL)
    table.insert(self.caneat, FOODTYPE.ELEMENTAL)
    self.inst:AddTag(FOODTYPE.ELEMENTAL.."_eater")
 
    local _tf = self.TestFood
    self.TestFood = function(self, food, testvalues)
        if food and food:HasTag("edible_"..FOODTYPE.ELEMENTAL) and food.prefab ~= "sdquartz" then
            return
        end
        return _tf(self, food, testvalues)
    end
 
    inst:ListenForEvent("oneat", function(inst, data)
        if data.food.prefab == "sdquartz" then
            inst.components.health:DoDelta(2.5)
            inst.components.sanity:DoDelta(2.5)
            inst.components.hunger:DoDelta(4) -- -12 + 2 = -10
        end
    end)
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(120)
	inst.components.hunger:SetMax(50)
	inst.components.sanity:SetMax(150)
	
	setCanEatQuartz(inst)
    inst.components.eater:SetOnEatFn(oneat1)
	
	inst.components.health.SetPenalty = function(self, penalty)
    self.penalty = math.clamp(penalty, 0, 0.25)
	end
	
	inst.components.sanity.neg_aura_mult = 1.3
		
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1.1
		
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 0.5 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

return MakePlayerCharacter("sdabigail", prefabs, assets, common_postinit, master_postinit, start_inv)
