local assets =
{
	Asset("ANIM", "anim/sdiridium.zip"),
    Asset("ATLAS", "images/inventoryimages/sdiridium.xml"),
	Asset("IMAGE", "images/inventoryimages/sdiridium.tex"),
}

local prefabs = 
{
}

-- Still does nothing. Dunno what it should do...
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    
	inst:AddTag("sdiridium")
	
    inst.MiniMapEntity:SetIcon("sdiridium.tex")
    inst.MiniMapEntity:SetPriority(5)
	
    if not TheWorld.ismastersim then
        return inst
    end
		
	inst.entity:SetPristine() 
    
    inst.AnimState:SetBank("sdiridium")
    inst.AnimState:SetBuild("sdiridium")
    inst.AnimState:PlayAnimation("idle", false)
	
    MakeHauntableLaunch(inst)
    inst:AddComponent("inspectable")
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	inst:AddComponent("edible")   
    inst.components.edible.foodtype = FOODTYPE.ELEMENTAL
    inst.components.edible.healthvalue = TUNING.HEALING_LARGE 
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE 
    inst.components.edible.sanityvalue = TUNING.SANITY_LARGE 
	
    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 10
				
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "sdiridium"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/sdiridium.xml"
	
    return inst
end

STRINGS.NAMES.SDIRIDIUM = "Iridium"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SDIRIDIUM = "An exotic ore with many curious properties. Can be smelted into bars."

return Prefab( "common/inventory/sdiridium", fn, assets) 