local assets =
{
	Asset("ANIM", "anim/sdiridiumbar.zip"),
    Asset("ATLAS", "images/inventoryimages/sdiridiumbar.xml"),
	Asset("IMAGE", "images/inventoryimages/sdiridiumbar.tex"),
}

local prefabs = 
{
}

-- Still does nothing. Dunno what it should do...
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    
	inst:AddTag("sdiridiumbar")
	
    inst.MiniMapEntity:SetIcon("sdiridiumbar.tex")
    inst.MiniMapEntity:SetPriority(5)
	
    if not TheWorld.ismastersim then
        return inst
    end
		
	inst.entity:SetPristine() 
    
    inst.AnimState:SetBank("sdiridiumbar")
    inst.AnimState:SetBuild("sdiridiumbar")
    inst.AnimState:PlayAnimation("idle", false)
	
    MakeHauntableLaunch(inst)
    inst:AddComponent("inspectable")
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
		
    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 15
				
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "sdiridiumbar"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/sdiridiumbar.xml"
	
    return inst
end

STRINGS.NAMES.SDIRIDIUMBAR = "Iridium Bar"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SDIRIDIUMBAR = "A bar of pure iridium."

return Prefab( "common/inventory/sdiridiumbar", fn, assets) 