local assets =
{
	Asset("ANIM", "anim/sdquartz.zip"),
    Asset("ATLAS", "images/inventoryimages/sdquartz.xml"),
	Asset("IMAGE", "images/inventoryimages/sdquartz.tex"),
}

local prefabs = 
{
}

-- Still does nothing. Dunno what it should do...
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    
	inst:AddTag("sdquartz")
	
    inst.MiniMapEntity:SetIcon("sdquartz.tex")
    inst.MiniMapEntity:SetPriority(5)
	
    if not TheWorld.ismastersim then
        return inst
    end
		
	inst.entity:SetPristine() 
    
    inst.AnimState:SetBank("sdquartz")
    inst.AnimState:SetBuild("sdquartz")
    inst.AnimState:PlayAnimation("idle", false)
	
    MakeHauntableLaunch(inst)
    inst:AddComponent("inspectable")
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	inst:AddComponent("edible")   
    inst.components.edible.foodtype = FOODTYPE.ELEMENTAL
    inst.components.edible.healthvalue = TUNING.HEALING_MEDSMALL * 1.5
    inst.components.edible.hungervalue = TUNING.CALORIES_LARGE 
    inst.components.edible.sanityvalue = TUNING.SANITY_SMALL
	
    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 5
				
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "sdquartz"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/sdquartz.xml"
	
    return inst
end

STRINGS.NAMES.SDQUARTZ = "Quartz"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SDQUARTZ = "A clear crystal commonly found in caves and mines."

return Prefab( "common/inventory/sdquartz", fn, assets) 