local assets =
{
	Asset("ANIM", "anim/sdquartzbar.zip"),
    Asset("ATLAS", "images/inventoryimages/sdquartzbar.xml"),
	Asset("IMAGE", "images/inventoryimages/sdquartzbar.tex"),
}

local prefabs = 
{
}

-- Still does nothing. Dunno what it should do...
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    
	inst:AddTag("sdquartzbar")
	
    inst.MiniMapEntity:SetIcon("sdquartzbar.tex")
    inst.MiniMapEntity:SetPriority(5)
	
    if not TheWorld.ismastersim then
        return inst
    end
		
	inst.entity:SetPristine() 
    
    inst.AnimState:SetBank("sdquartzbar")
    inst.AnimState:SetBuild("sdquartzbar")
    inst.AnimState:PlayAnimation("idle", false)
	
    MakeHauntableLaunch(inst)
    inst:AddComponent("inspectable")
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
		
    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 10
				
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "sdquartzbar"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/sdquartzbar.xml"
	
    return inst
end

STRINGS.NAMES.SDQUARTZBAR = "Refined Quartz"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SDQUARTZBAR = "A more pure form of quartz."

return Prefab( "common/inventory/sdquartzbar", fn, assets) 