local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local TECH = GLOBAL.TECH

--modimport("scripts/prefabs/righteous_hammer.lua")

PrefabFiles = {
	"arthas",
	"wood_hammer",
	"trial_hammer",
	"holy_hammer",
    "righteous_hammer",
    "arthas_defence",
    "shengguang",
    "sgfire",
    "sq_bianshen",
    "sq_gongji",
    "sq_hudun",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/arthas.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/arthas.xml" ),

    Asset( "IMAGE", "images/avatars/avatar_arthas.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_arthas.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/arthas.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/arthas.xml" ),

    Asset( "IMAGE", "bigportraits/arthas.tex" ),
    Asset( "ATLAS", "bigportraits/arthas.xml" ),
	
	Asset( "IMAGE", "images/map_icons/arthas.tex" ),
	Asset( "ATLAS", "images/map_icons/arthas.xml" ),
--[[]]
    Asset("IMAGE", "images/arthastabs/arthastab.tex"),
    Asset("ATLAS", "images/arthastabs/arthastab.xml"),

    Asset("IMAGE", "images/inventoryimages/wood_hammer.tex"),
    Asset("ATLAS", "images/inventoryimages/wood_hammer.xml"),

    Asset("IMAGE", "images/inventoryimages/trial_hammer.tex"),
    Asset("ATLAS", "images/inventoryimages/trial_hammer.xml"),

    Asset("IMAGE", "images/inventoryimages/holy_hammer.tex"),
    Asset("ATLAS", "images/inventoryimages/holy_hammer.xml"),

    Asset("IMAGE", "images/inventoryimages/righteous_hammer.tex"),
    Asset("ATLAS", "images/inventoryimages/righteous_hammer.xml"),

    Asset("IMAGE", "images/inventoryimages/arthas_defence.tex"),
    Asset("ATLAS", "images/inventoryimages/arthas_defence.xml"),

}

GLOBAL.STRINGS.NAMES.WOOD_HAMMER = "wood_hammer"
GLOBAL.STRINGS.RECIPE_DESC.WOOD_HAMMER = "A wood_hammer!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.WOOD_HAMMER = "wood_hammer"

GLOBAL.STRINGS.NAMES.TRIAL_HAMMER = "trial_hammer"
GLOBAL.STRINGS.RECIPE_DESC.TRIAL_HAMMER = "A trial_hammer!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TRIAL_HAMMER = "trial_hammer"

GLOBAL.STRINGS.NAMES.HOLY_HAMMER = "holy_hammer"
GLOBAL.STRINGS.RECIPE_DESC.HOLY_HAMMER = "A holy_hammer!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.HOLY_HAMMER = "holy_hammer"

GLOBAL.STRINGS.NAMES.RIGHTEOUS_HAMMER = "righteous_hammer"
GLOBAL.STRINGS.RECIPE_DESC.RIGHTEOUS_HAMMER = "A righteous hammer!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RIGHTEOUS_HAMMER = "righteous_hammer"

GLOBAL.STRINGS.NAMES.ARTHAS_DEFENCE = "Arthas_defence!"
GLOBAL.STRINGS.RECIPE_DESC.ARTHAS_DEFENCE = "An arthas_defence!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ARTHAS_DEFENCE = "arthas_defence!"

STRINGS.CHARACTER_TITLES.arthas = "Arthas"
STRINGS.CHARACTER_NAMES.arthas = "Arthas"
STRINGS.CHARACTER_DESCRIPTIONS.arthas = "Justice And Redemption"
STRINGS.CHARACTER_QUOTES.arthas = "Justice And Redemption"

function arthasPostInit(arthas)

    local wood_hammer = Recipe("wood_hammer", {Ingredient("log", 3)}, RECIPETABS.ARTHASTAB, {SCIENCE = 0})
    wood_hammer.atlas = "images/inventoryimages/wood_hammer.xml"

    local wood_hammer = Ingredient( "wood_hammer", 1)
    wood_hammer.atlas = "images/inventoryimages/wood_hammer.xml"

    local trial_hammer = Recipe("trial_hammer", {wood_hammer, Ingredient("goldnugget", 3)}, RECIPETABS.ARTHASTAB, {SCIENCE = 0})
    trial_hammer.atlas = "images/inventoryimages/trial_hammer.xml"

    local holy_hammer = Recipe("holy_hammer", {wood_hammer, Ingredient("livinglog", 3)}, RECIPETABS.ARTHASTAB, {SCIENCE = 0})
    holy_hammer.atlas = "images/inventoryimages/holy_hammer.xml"

    local trial_hammer = Ingredient( "trial_hammer", 1)
    trial_hammer.atlas = "images/inventoryimages/trial_hammer.xml"

    local holy_hammer = Ingredient( "holy_hammer", 1)
    holy_hammer.atlas = "images/inventoryimages/holy_hammer.xml"

    local righteous_hammer = Recipe("righteous_hammer", {trial_hammer, holy_hammer}, RECIPETABS.ARTHASTAB, {SCIENCE = 3})
    righteous_hammer.atlas = "images/inventoryimages/righteous_hammer.xml"

    local arthas_defence = Recipe("arthas_defence", {Ingredient("goldnugget", 3)}, RECIPETABS.ARTHASTAB, {SCIENCE = 0})
    arthas_defence.atlas = "images/inventoryimages/arthas_defence.xml"
end

function AddMap(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( inst.prefab .. ".tex" )
end
AddPrefabPostInit("righteous_hammer", AddMap)
AddMinimapAtlas("images/inventoryimages/righteous_hammer.xml")

AddPrefabPostInit("arthas_defence", AddMap)
AddMinimapAtlas("images/inventoryimages/arthas_defence.xml")

table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "arthas")
AddMinimapAtlas("images/map_icons/arthas.xml")
AddModCharacter("arthas")

AddSimPostInit(function(inst)
        if inst.prefab == "arthas" then
               arthasPostInit(inst)
        end
end)

--外交属性：威胁为0
local function RecheckForThreat(inst)
    local busy = inst.sg:HasStateTag("sleeping") or inst.sg:HasStateTag("busy") or inst.sg:HasStateTag("flying")
    if not busy then
        local threat = GLOBAL.FindEntity(inst, 5, nil, nil, {'notarget', 'diplomacy'}, {'player', 'monster', 'scarytoprey'})
        return threat ~= nil
    end
end
 
AddStategraphPostInit("bird", function(sg)
    local old = sg.events.flyaway.fn
    sg.events.flyaway.fn = function(inst)
        if RecheckForThreat(inst) then
            old(inst)
        end
    end
end)

