local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/arthas.zip" ),
        Asset( "ANIM", "anim/arthas_change.zip" ),
        Asset( "IMAGE", "images/arthastabs/arthastab.tex"),
        Asset( "ATLAS", "images/arthastabs/arthastab.xml"),
}
local prefabs = {
    
}

-- Custom starting items
local start_inv = {
    "wood_hammer",
}


local max_upgrades = 10
local function applyupgrades(inst)

    local upgrades = math.min(inst.level, max_upgrades)

    local hunger_percent = inst.components.hunger:GetPercent()
    local health_percent = inst.components.health:GetPercent()
    local sanity_percent = inst.components.sanity:GetPercent()

    inst.components.health.maxhealth = math.ceil (100 + upgrades * 5)
    inst.components.sanity.max = math.ceil (130 + upgrades * 5)
    inst.components.hunger.max = math.ceil (95 + upgrades * 2.5)
    inst.components.locomotor.walkspeed =  math.ceil (4 * (upgrades/100+1))
    inst.components.locomotor.runspeed = math.ceil (6 * (upgrades/100+1))
    if inst.components.combat.attack_damage_modifiers then
        inst.components.combat.attack_damage_modifiers[1] = (upgrades/100*2-0.1)
    else
        inst.components.combat.damagemultiplier = (1 * (upgrades/100*2+0.9))
    end
    inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * (1+ upgrades/20)
    inst.components.combat.min_attack_period = 0.5-upgrades*0.15
    inst.components.talker:Say("Level Up! : ".. (inst.level)) 
    if inst.level >= 10 then
        inst.components.talker:Say("Level Max!")
    end
    --inst.components.health:SetAbsorptionAmount(1)
    local qishi_change =false
--骑士的荣耀：5级解锁，每秒损失2 sanity / 1.5 hungry 伤害上升1.2-1.4，防御力上升25%-50%，生命回复0.5/s   再次按Z还原（按Z）
TheInput:AddKeyDownHandler(KEY_Z, function()           
if inst.level >= 5 then 
    if  inst.components.sanity.current > -30
    and inst.components.hunger.current > -30 then
        if  not qishi_change then
            qishi_change = true
            
            local sq_bianshen = SpawnPrefab("sq_bianshen")
            sq_bianshen.entity:SetParent(inst.entity)
            sq_bianshen.Transform:SetPosition(0, 0.2, 0)
            sq_bianshen.AnimState:PlayAnimation("idle_sq_bianshen",true)
            inst:DoTaskInTime(0.6, function()
                sq_bianshen.kill_fx(sq_bianshen)
                inst.AnimState:SetBuild("arthas_change")
                inst.components.talker:Say("I'm justice!")
            end)

            inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*(1+ upgrades/20)-1.5)
            TUNING.SANITY_DAY_GAIN=-2--100/(day_time*32),
            TUNING.SANITY_NIGHT_LIGHT=-100/(60*20)-2
            TUNING.SANITY_NIGHT_MID=-100/(60*20)-2
            TUNING.SANITY_NIGHT_DARK=-100/(60*2)-2
            inst.components.health:StartRegen(0.5, 1)
            inst.components.health.absorb = upgrades/10 * 0.5
            if inst.components.combat.attack_damage_modifiers then
                inst.components.combat.attack_damage_modifiers[1] = (upgrades/100*4)
            else
                inst.components.combat.damagemultiplier = (upgrades/100*4+1)
            end
        else
            qishi_change = false
            inst.AnimState:SetBuild("arthas")
            inst.components.talker:Say("I'm back!")

            inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*(1 + upgrades/20))
            TUNING.SANITY_DAY_GAIN= 0--100/(day_time*32),        
            TUNING.SANITY_NIGHT_LIGHT=-100/(60*20)
            TUNING.SANITY_NIGHT_MID=-100/(60*20)
            TUNING.SANITY_NIGHT_DARK=-100/(60*2)
            inst.components.health:StartRegen(0, 1)
            inst.components.health.absorb = 0
            if inst.components.combat.attack_damage_modifiers then
                inst.components.combat.attack_damage_modifiers[1] = (upgrades/100*2-0.1)
            else
                inst.components.combat.damagemultiplier = (upgrades/100*2 + 0.9)
            end
        end
    else
        inst.components.talker:Say("I need more power!")
    end
else
    inst.components.talker:Say("I need level-5!")
end
end)

--[[]]
--神圣怒火：10级解锁，以人物为中心，牺牲一半精神值，造成等消耗精神值2倍的伤害，所有可燃物也会燃烧起来
TheInput:AddKeyDownHandler(KEY_X, function()
local sanity_c = inst.components.sanity.current
if inst.level >= 10 then
    if sanity_c > 0 then
        
 --读书动作
        inst.components.locomotor:Stop()
        inst.components.playercontroller:Enable(false)
        inst:DoTaskInTime(0.1, function()
            inst.AnimState:PlayAnimation("book")
            inst.AnimState:OverrideSymbol("book_open", "book_uniqueitem_swap", "book_open")
            inst.AnimState:OverrideSymbol("book_closed", "book_uniqueitem_swap", "book_closed")
            inst.AnimState:OverrideSymbol("book_open_pages", "book_uniqueitem_swap", "book_open_pages")
            inst.SoundEmitter:PlaySound("dontstarve/common/use_book")
            local fxtoplay = "book_fx"
            if inst.prefab == "waxwell" then
                fxtoplay = "waxwell_book_fx" 
            end
            local fx = SpawnPrefab(fxtoplay)
            local pos = inst:GetPosition()
            fx.Transform:SetRotation(inst.Transform:GetRotation())
            fx.Transform:SetPosition( pos.x, pos.y - .2, pos.z ) 
            inst.sg.statemem.book_fx = fx
        end)
--[[]]        
--1.5s后，释放火焰效果
        inst:DoTaskInTime(1.5, function()
            local sgfire = SpawnPrefab("sgfire")
            sgfire.entity:SetParent(inst.entity)
            sgfire.Transform:SetPosition(0, 1.2, 0)
            sgfire.AnimState:PlayAnimation("idle_sgfire",true)
            inst:DoTaskInTime(0.8, function()
                sgfire.kill_fx(sgfire)
                inst.components.playercontroller:Enable(true)
                inst.components.sanity:DoDelta(-sanity_c/2)
            end)
        end)

--1.5s后，8码范围内敌人会燃烧
        inst:DoTaskInTime(1.5, function()
            local x,y,z = inst.Transform:GetWorldPosition()
            local NO_TAGS = {"FX", "NOCLICK","DECOR","INLIMBO", "player","wall", "structure"}
            local ents = TheSim:FindEntities(x, y, z, 8, {"burnable"}, NO_TAGS) 
            for i,v in pairs(ents) do
                if v.components.burnable then
                    v.components.burnable:Ignite()
                    if v.components.health then
                        v.components.health:DoDelta(-sanity_c)
                    end
                end
            end
        end)

    else
        inst.components.talker:Say("I need more sanity!")
    end
else
    inst.components.talker:Say("I need level-10!")
end
end)
end
--攻击怪物属性生物，伤害上升0.15
local function onattack(inst, data)
    if data.target:HasTag("monster") then 
        if inst.components.combat.attack_damage_modifiers then
            inst.components.combat.attack_damage_modifiers[1] = (inst.level/100*1.5-0.1)
        else
            inst.components.combat.damagemultiplier = (inst.level/100*1.5 + 0.9)
        end
    end
end

local function onkill(inst, data)
    local iflevelup = false
    if data.cause == inst.prefab and not data.inst:HasTag("companion") then
        if  data.inst:HasTag("moose") 
            or data.inst:HasTag("dragonfly")
            or data.inst:HasTag("bearger")
            or data.inst:HasTag("deerclops") 
            then
            iflevelup = true
        elseif 
            data.inst:HasTag("monster")
            and not data.inst:HasTag("insect") 
            and not data.inst:HasTag("eyeplant") 
            then
            inst.xpnow = inst.xpnow + 1
        end
    end

    if inst.xpnow >= 5*(inst.level + 1) then
        iflevelup =true
    end

    if iflevelup and inst.level < max_upgrades then
        inst.level = inst.level + 1
        inst.xpnow = 0
        applyupgrades(inst) 

        inst.components.sanity:DoDelta(inst.components.sanity.max*0.2)
        inst.components.health:DoDelta(inst.components.health.maxhealth*0.15)
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()

        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
    end

end

local function onload(inst)
    inst:ListenForEvent("onattackother", onattack)
end

local function onpreload(inst, data)
    if data then
        if data.level then
            inst.level = data.level
            applyupgrades(inst)
            --reset these from the save data, because of load-order clipping issues
            if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
            if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
            if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
            inst.components.health:DoDelta(0)
            inst.components.hunger:DoDelta(0)
            inst.components.sanity:DoDelta(0)
        end
       
        if  data.xpnow then
            inst.xpnow = data.xpnow
            onkill(inst, data)
        end
     
    end
end

local function onsave(inst, data)
    data.level = inst.level
    data.xpnow = inst.xpnow
end

local fn = function(inst)
    RECIPETABS['ARTHASTAB'] = {str = "ARTHASTAB", sort=999, icon = "arthastab.tex", icon_atlas = "images/arthastabs/arthastab.xml"}
    inst.Transform:SetScale(1.1,1.1,1.1)

    inst.soundsname = "willow"

    inst.MiniMapEntity:SetIcon( "arthas.tex" )
    inst:AddTag("diplomacy")
    inst:RemoveTag("scarytoprey")

    inst.components.health:SetMaxHealth(150)
    inst.components.hunger:SetMax(120)
    inst.components.sanity:SetMax(180)

    inst.components.combat.damagemultiplier = 1

    inst.level = 0
    inst.xpnow = 0
    applyupgrades(inst)
    inst.OnSave = onsave
    inst.OnPreLoad = onpreload
    inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())

TheInput:AddKeyDownHandler(KEY_L, function()
    if  inst.level < max_upgrades then
        inst.components.talker:Say("EXP  "..(inst.xpnow).."/"..(5*(inst.level + 1)))
    else
        inst.components.talker:Say("Wind : Max!")
    end
    end)

    inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 6
end

return MakePlayerCharacter("arthas", prefabs, assets, fn, start_inv)
