local assets=
{
    Asset("ANIM", "anim/arthas_defence.zip"),
    Asset("ATLAS", "images/inventoryimages/arthas_defence.xml")
}

local function arthas_defence(inst, owner)
    inst.components.armor:SetAbsorption(1)
    
    local sq_hudun = SpawnPrefab("sq_hudun")
    sq_hudun.entity:SetParent(owner.entity)
    sq_hudun.Transform:SetPosition(0, 0.2, 0)
    sq_hudun.Transform:SetScale(0.7, 0.7, 0.7)
    sq_hudun.AnimState:PlayAnimation("hit")
    sq_hudun.AnimState:PushAnimation("idle_loop")

    inst.components.armor.ontakedamage = function(inst, damage_amount)
        if owner then
            local sanity = owner.components.sanity
            if sanity then
                local unsaneness = damage_amount * TUNING.ARMOR_RUINSHAT_DMG_AS_SANITY
                sanity:DoDelta(-unsaneness, false)
            end
        end
    end
    inst.active = true
    --冷却时间30s，持续1.5s
    owner:DoTaskInTime(1.5, function()
        sq_hudun.kill_fx(sq_hudun)
        if inst:IsValid() then
            inst.components.armor.ontakedamage = nil
            --owner.components.health.absorb = 0
            inst.components.armor:SetAbsorption(0)
            owner:DoTaskInTime(30, function() inst.active = false end)
        end
    end)
end
--100%概率触发
local function tryproc(inst, owner)
    if not inst.active 
    	--and math.random() < 0.5 
    	then
        arthas_defence(inst, owner)
    end
end


local function onequip(inst, owner) 
        inst.procfn = function() tryproc(inst, owner) end
        owner:ListenForEvent("attacked", inst.procfn)
end

local function onunequip(inst, owner) 
        owner:RemoveEventCallback("attacked", inst.procfn)
end

local function ondrop(inst)

end


local function fn(Sim)
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("arthas_defence")
    inst.AnimState:SetBuild("arthas_defence")
    inst.AnimState:PlayAnimation("idel")
    MakeInventoryPhysics(inst)

    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/arthas_defence.xml"
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    --护甲吸收0.8伤害，护甲共可吸收10000生命
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(200, 0)
    --inst:ListenForEvent("percentusedchange", gcPercentChanged)

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.inventoryitem:SetOnDroppedFn(ondrop)

    return inst
end
return Prefab( "common/inventory/arthas_defence", fn, assets)

