local assets=
{
    Asset("ANIM", "anim/holy_hammer.zip"),
    Asset("ANIM", "anim/swap_holy_hammer.zip"),
  
    Asset("ATLAS", "images/inventoryimages/holy_hammer.xml"), 
    Asset("IMAGE", "images/inventoryimages/holy_hammer.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_holy_hammer", "swap_frostmourne")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 

    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

local function cure_fn(inst, target)
    local owner = inst.components.inventoryitem.owner
    if owner.components.sanity.current >= 30 then
        if owner.components.health.currenthealth < owner.components.health.maxhealth then
            owner.components.health:DoDelta(15)
            owner.components.sanity:DoDelta(-30)
            local shengguang = SpawnPrefab("shengguang")
            shengguang.entity:SetParent(owner.entity)
            shengguang.Transform:SetPosition(0, 0.2, 0)
            shengguang.AnimState:PlayAnimation("idle_sg",true)
            owner:DoTaskInTime(1, function()
                shengguang.kill_fx(shengguang)
            end)
            owner.components.talker:Say("Lay on Hands!")
            inst.components.finiteuses:Use(30)
        else
            owner.components.talker:Say("I'm healthy!")
        end
    else
        owner.components.talker:Say("I need more sanity!")
    end
end


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("holy_hammer")
    inst.AnimState:SetBuild("holy_hammer")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(cure_fn)
    inst.components.spellcaster.castingstate = "castspell_tornado"
    inst.components.spellcaster.canuseonpoint = true
    inst.components.spellcaster.canusefrominventory = false
    inst.components.spellcaster.canonlyuseonlocomotors = true

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/holy_hammer.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


local function onattack(inst, owner, target)
    owner.components.sanity:DoDelta(0.5)
end

    inst:AddTag("sharp")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(300)
    inst.components.finiteuses:SetUses(300)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    return inst
end
    

return Prefab( "common/inventory/holy_hammer", fn, assets) 
