local assets=
{
    Asset("ANIM", "anim/righteous_hammer.zip"),
    Asset("ANIM", "anim/swap_righteous_hammer.zip"),
  
    Asset("ATLAS", "images/inventoryimages/righteous_hammer.xml"), 
    Asset("IMAGE", "images/inventoryimages/righteous_hammer.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_righteous_hammer", "swap_ham_bat")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end
--右键回复自身生命值：（随人物等级10-40）耗费sanity20-50（基于人物等级）
local function cure_fn(inst, target)
	local owner = inst.components.inventoryitem.owner
	local cure_health = (owner.level+1)*3+10
	local cost_sanity = (owner.level+1)*3+20
    if owner.components.sanity.current >= cost_sanity then
    	if owner.components.health.currenthealth < owner.components.health.maxhealth then
        	owner.components.health:DoDelta(cure_health)
        	owner.components.sanity:DoDelta(-cost_sanity)
        	local shengguang = SpawnPrefab("shengguang")
            shengguang.entity:SetParent(owner.entity)
            shengguang.Transform:SetPosition(0, 0.2, 0)
            shengguang.AnimState:PlayAnimation("idle_sg",true)
            owner:DoTaskInTime(1, function()
                shengguang.kill_fx(shengguang)
            end)
        	owner.components.talker:Say("Lay on Hands!")
        else
    		owner.components.talker:Say("I'm healthy!")
    	end
    else
    	owner.components.talker:Say("I need more sanity!")
    end
end


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("batbat")
    inst.AnimState:SetBuild("righteous_hammer")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(cure_fn)
    inst.components.spellcaster.castingstate = "castspell_tornado"
    inst.components.spellcaster.canuseonpoint = true
    inst.components.spellcaster.canusefrominventory = false
    inst.components.spellcaster.canonlyuseonlocomotors = true

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/righteous_hammer.xml"

	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst.shensheng = 0

--圣锤righteous_hammer：每次攻击回复0.5sanity，无耐久，
--攻击怪物属性的生物，触发神圣审判，造成额外伤害（3-15）（基于人物等级）
--神圣溅射，第三次攻击会造成3*3范围伤害
local function onattack(inst, owner, target)
    inst.shensheng = inst.shensheng +1
    owner.components.sanity:DoDelta(owner.level/10)
    if  owner.prefab == "arthas" and target:HasTag("monster") then
        --owner.components.talker:Say("Power!")
        target.components.health:DoDelta(-(owner.level+5))
        local sq_gongji = SpawnPrefab("sq_gongji")
        sq_gongji.entity:SetParent(target.entity)
        sq_gongji.Transform:SetPosition(0, 0.2, 0)
        sq_gongji.AnimState:PlayAnimation("idle_sq_gongji",true)
        inst:DoTaskInTime(0.5, function()
            sq_gongji.kill_fx(sq_gongji)
        end)
--[[]]
    end
    if inst.shensheng % 3 == 0 then
        owner.components.combat.areahitrange = 3
        --owner.components.talker:Say("Power!")
    else
        owner.components.combat.areahitrange = nil
        --owner.components.talker:Say("Attack!")
    end
end

    inst:AddTag("sharp")
    inst:AddComponent("weapon")
    --inst.components.weapon:SetDamage(34*0.8)
    inst.components.weapon:SetDamage(34*0.8+13*0.04*inst.level)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)

	return inst
end
	

return Prefab( "common/inventory/righteous_hammer", fn, assets) 
