local assets = 
{
   Asset("ANIM", "anim/sq_hudun.zip")
}

local function kill_fx(inst)
    inst.AnimState:PlayAnimation("nil")
    inst:DoTaskInTime(1.5, function() inst:Remove() end)    
end

local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()

    anim:SetBank("sq_hudun")
    anim:SetBuild("sq_hudun")
    anim:PlayAnimation("nil")
    anim:PlayAnimation("hit")
    anim:PushAnimation("idle_loop")

    --anim:SetOrientation( ANIM_ORIENTATION.OnGround )
    --anim:SetLayer( LAYER_BACKGROUND )
    --anim:SetSortOrder( 3 )

    inst.kill_fx = kill_fx

    return inst
end

return Prefab( "common/sq_hudun", fn, assets) 
