local assets=
{
    Asset("ANIM", "anim/trial_hammer.zip"),
    Asset("ANIM", "anim/swap_trial_hammer.zip"),
  
    Asset("ATLAS", "images/inventoryimages/trial_hammer.xml"), 
    Asset("IMAGE", "images/inventoryimages/trial_hammer.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_trial_hammer", "swap_frostmourne")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 

    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("trial_hammer")
    inst.AnimState:SetBuild("trial_hammer")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/trial_hammer.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

local function onattack(inst, owner, target)
    if  owner.prefab == "arthas" and target:HasTag("monster") then
        --owner.components.talker:Say("Power!")
        target.components.health:DoDelta(-(owner.level+5))
        local sq_gongji = SpawnPrefab("sq_gongji")
        sq_gongji.entity:SetParent(target.entity)
        sq_gongji.Transform:SetPosition(0, 0.2, 0)
        sq_gongji.AnimState:PlayAnimation("idle_sq_gongji",true)
        inst:DoTaskInTime(0.5, function()
            sq_gongji.kill_fx(sq_gongji)
        end)
    end
end

    inst:AddTag("sharp")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(240)
    inst.components.finiteuses:SetUses(240)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    return inst
end
    

return Prefab( "common/inventory/trial_hammer", fn, assets) 
