local assets=
{
    Asset("ANIM", "anim/wood_hammer.zip"),
    Asset("ANIM", "anim/swap_wood_hammer.zip"),
  
    Asset("ATLAS", "images/inventoryimages/wood_hammer.xml"), 
    Asset("IMAGE", "images/inventoryimages/wood_hammer.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_wood_hammer", "swap_frostmourne")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 

    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("wood_hammer")
    inst.AnimState:SetBuild("wood_hammer")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wood_hammer.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(34*0.8)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(120)
    inst.components.finiteuses:SetUses(120)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    return inst
end
    

return Prefab( "common/inventory/wood_hammer", fn, assets) 
