package mods.touhou_alice_extras.AI;

import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.DamageSource;

import mods.touhou_alice_core.AI.EntityDollAIBase;
import mods.touhou_alice_core.EntityAliceDoll;

import java.util.*;
import java.util.regex.*;

public class EntityDollAIAttackWithGoliath extends EntityDollAIBase
{
    private PathNavigate pathfinder;
    private EntityLivingBase theTarget;
    private float speed;
    private int counter;
    private int targetLost;
    private boolean avoidsWater;
    public static double searchRange;
    public static double searchHeight;
    public static String targetEntityRegex;
    public static int attackStrength;

    public EntityDollAIAttackWithGoliath(EntityAliceDoll doll)
    {
        super(doll);
        this.speed = 1.0F;
        this.pathfinder = doll.getNavigator();
        this.setMutexBits(3);
        counter = 0;
    }

    @Override
    public boolean shouldExecute()
    {
        if(!theDoll.isEnable())
        {
            return false;
        }
        if(theDoll.isStandbyMode() || theDoll.isRideonMode())
        {
            return false;
        }
        if(--counter > 0)
        {
            return false;
        }
        counter = 20;
        
        //攻撃対象設定
        Pattern targetPattern = Pattern.compile(targetEntityRegex);
        Matcher targetMatcher;
        List<EntityLivingBase> targetList =
            (List<EntityLivingBase>)(theWorld.getEntitiesWithinAABB(EntityLivingBase.class, theDoll.boundingBox.expand(searchRange, searchHeight, searchRange)));
        theTarget = null;
        for(EntityLivingBase e : targetList)
        {
            String name = EntityList.getEntityString(e);
            if(name == null || name == "")
            {
                name = "unknown";
            }
            
            if(theDoll.isPatrolMode())
            {
                targetMatcher = targetPattern.matcher(name);
                if(targetMatcher.find())
                {
                    if(theTarget == null)
                    {
                        theTarget = e;
                    }
                    else
                    {
                        if(theDoll.getDistanceSqToEntity(theTarget)
                           > theDoll.getDistanceSqToEntity(e))
                        {
                            theTarget = e;
                        }
                    }
                }
            }
        
            if(theDoll.isFollowMode())
            {
                Entity tt = null;
                if(e instanceof EntityCreature)
                {
                    tt = ((EntityCreature)e).getEntityToAttack();
                }
                else if(e instanceof EntityLiving)
                {
                    tt = ((EntityLiving)e).getAttackTarget();
                }
                if(theDoll.isOwner(tt))
                {
                    if(theTarget == null)
                    {
                        theTarget = e;
                    }
                    else
                    {
                        if(theDoll.getDistanceSqToEntity(theTarget)
                           > theDoll.getDistanceSqToEntity(e))
                        {
                            theTarget = e;
                        }
                    }
                }
            }
        }
        
        if(theTarget == null)
        {
            return false;
        }

        return true;
    }

    @Override
    public void startExecuting()
    {
        counter = 0;
        targetLost = 0;
        this.avoidsWater = this.theDoll.getNavigator().getAvoidsWater();
        this.theDoll.getNavigator().setAvoidsWater(false);
    }

    @Override
    public boolean continueExecuting()
    {
        if(!theDoll.isEnable())
        {
            return false;
        }
        if(theDoll.isStandbyMode() || theDoll.isRideonMode())
        {
            return false;
        }
        if(this.pathfinder.noPath())
        {
            return false;
        }
        if(this.theTarget == null)
        {
            return false;
        }
        if(!this.theTarget.isEntityAlive())
        {
            return false;
        }
        if(targetLost >= 60)
        {
            return false;
        }
        return true;
    }

    @Override
    public void resetTask()
    {
        this.theTarget = null;
        this.pathfinder.clearPathEntity();
        this.theDoll.getNavigator().setAvoidsWater(this.avoidsWater);
        counter = 0;
    }

    @Override
    public void updateTask()
    {
        if(!this.theTarget.isEntityAlive())
        {
            return;
        }
        if(!this.pathfinder.noPath() &&
           this.theDoll.getEntitySenses().canSee(this.theTarget))
        {
            this.theDoll.getLookHelper().setLookPositionWithEntity(
                this.theTarget, 10.0F, (float)this.theDoll.getVerticalFaceSpeed());
            targetLost = targetLost > 0 ? (targetLost - 1) : 0;
        }
        else
        {
            targetLost++;
        }

        if (--this.counter <= 0)
        {
            this.counter = 20;

            this.pathfinder.tryMoveToEntityLiving(this.theTarget, this.speed);
            if(this.theDoll.getDistanceSqToEntity(this.theTarget) < 16f
               && this.theDoll.getEntitySenses().canSee(this.theTarget)
               && this.theTarget.isEntityAlive())
            {
                this.theDoll.swingItem();

                if(theDoll.getOwnerEntity() != null)
                {
                    if(theTarget.attackEntityFrom(
                        DamageSource.causePlayerDamage(
                            theDoll.getOwnerEntity()),attackStrength))
                    {
                        double dx = theTarget.posX-theDoll.posX;
                        double dz = theTarget.posZ-theDoll.posZ;
                        double dr = Math.sqrt(dx*dx+dz*dz+0.01D);
                        theTarget.motionX += dx/dr;
                        theTarget.motionY += 0.1D;
                        theTarget.motionZ += dz/dr;
                        theDoll.playSound("mob.blaze.hit", 0.8F,1.0F);
                    }
                }
                else
                {
                    if(theTarget.attackEntityFrom(
                        DamageSource.causeMobDamage(
                            theDoll),attackStrength))
                    {
                        double dx = theTarget.posX-theDoll.posX;
                        double dz = theTarget.posZ-theDoll.posZ;
                        double dr = Math.sqrt(dx*dx+dz*dz+0.01D);
                        theTarget.motionX += dx/dr;
                        theTarget.motionY += 0.1D;
                        theTarget.motionZ += dz/dr;
                        theDoll.playSound("mob.blaze.hit", 0.8F,1.0F);
                    }
                }
            }
        }
    }
}
