<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/LiveClientService.php";
    require_once "handle/service/ServerStartUpService.php";
    require_once "handle/service/ServerStartUpConfig.php";
    require_once "handle/service/DiskMediaService.php";
    require_once "handle/util/AMSUtil.php";


    $media_service = new DiskMediaService();
    $liveClient = new LiveClientService();
    $startup = new ServerStartUpService();

    $action = AMSUtil::get_http_parameter("action");

    if($action == "get_whole_medias")
    {
        $liveId = AMSUtil::get_http_parameter("liveId");
        $media_list = $media_service->get_whole_medias($liveId);
        $json = json_encode($media_list);
        echo $json;
    }
    else if($action == "search_media")
    {
        $key = AMSUtil::get_http_parameter("key");
        $liveId = AMSUtil::get_http_parameter("liveId");
        $media_list = $media_service->get_whole_medias($liveId);
        $media_soso_list = array();
        foreach($media_list as $val)
        {
            $index = strpos($val->name,$key);
            if($index === false)
                $index = -1;

            if($index!=-1 || $val->name==$key)
            {
                $red_fname = str_replace($key,"<font color='#990000'>$key</font>",$val->name);
                $val->name = $red_fname;
                $media_soso_list[] = $val;
            }
        }

        $json = json_encode($media_soso_list);
        echo $json;
    }
    else if($action == "play_url")
    {
        $liveId = AMSUtil::get_http_parameter("id");
        $live = $liveClient->getLiveChannelInfo($liveId);
        $startUpConfig = $startup->getServerStartUp();

        $ip = ServerStartUpConfig::getInstance()->ip;
        $port = ServerStartUpConfig::getInstance()->port;
        $rtsp_port = $startUpConfig->rtsp_port;
        $hls_web_path =ServerStartUpConfig::getInstance()->hls_web_path;

        $rtmp_play_url = "rtmp://".$ip.":".$port."/".$live->appName."/".$live->name;
        $rtsp_play_url = "rtsp://".$ip.":".$rtsp_port."/".$live->appName."/".$live->name;
        $hls_play_url = $hls_web_path.$live->appName."/".$live->name."/stream.m3u8";

        $json = array();
        $json["rtmp_play_url"] = $rtmp_play_url;
        $json["rtsp_play_url"] = $rtsp_play_url;
        $json["hls_play_url"] = $hls_play_url;

        echo json_encode($json);
    }






