<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/LiveClientService.php";
    require_once "handle/service/VodsClientService.php";
    require_once "handle/service/PlayItemService.php";
    require_once "handle/service/ServerStartUpService.php";
    require_once "handle/util/AMSUtil.php";


    $liveClient = new LiveClientService();
    $vodClient = new VodsClientService();
    $playItemService = new PlayItemService();
    $serverService = new ServerStartUpService();

    $action = AMSUtil::get_http_parameter("action");
    $dialog = AMSUtil::get_http_parameter("dialog");
    
    if($action == "list")
    {
        $type = AMSUtil::get_http_parameter("channel_type");
        $json = "";
        if($type == "" || intval($type) == 0)
        {
            $list = $liveClient->getListLiveInfos();
            $json = json_encode($list);
        }
        else
        {
            $list = $liveClient->getListLiveInfosByType($type);
            $json = json_encode($list);
        }

        echo $json;
    }
    else if($action == "add")
    {
       $appName = AMSUtil::get_http_parameter("appName");
       $liveName = AMSUtil::get_http_parameter("liveName");
       $alias = AMSUtil::get_http_parameter("alias");
        
       $isPush = AMSUtil::get_http_parameter("isPush");
       $lazyPull  = AMSUtil::get_http_parameter("lazyPull");
       $recordAppend  = AMSUtil::get_http_parameter("recordAppend");	
       $right = AMSUtil::get_http_parameter("right");
        
       $recordEnabled = AMSUtil::get_http_parameter("recordEnabled");
       $recordType = AMSUtil::get_http_parameter("recordType");
       $format = AMSUtil::get_http_parameter("format");
        
       $enableHLS = AMSUtil::get_http_parameter("enableHLS");
       $enableTS = AMSUtil::get_http_parameter("enableTS");
       $tsAddress = AMSUtil::get_http_parameter("tsAddress");
        
       $flvKeyframe = AMSUtil::get_http_parameter("flvKeyframe");
       $keepPlaybackDays = AMSUtil::get_http_parameter("keepPlaybackDays");
       $liveProperty = AMSUtil::get_http_parameter("liveProperty");
       $outputMode = AMSUtil::get_http_parameter("outputMode");
        
       $appendTime = AMSUtil::get_http_parameter("appendTime");
       $intervalTime = AMSUtil::get_http_parameter("intervalTime");
        
        /*
         * 拉流详情数据
         */
        $url = AMSUtil::get_http_parameter('url');
        $vTransfer = AMSUtil::get_http_parameter('vTransfer');
        $width = AMSUtil::get_http_parameter('width');
        $height = AMSUtil::get_http_parameter('height');
        $frameRate = AMSUtil::get_http_parameter('frameRate');
        $vBitRate = AMSUtil::get_http_parameter('vBitRate');
        $gop = AMSUtil::get_http_parameter('gop');

        $aTransfer = AMSUtil::get_http_parameter('aTransfer');
        $sampleRate = AMSUtil::get_http_parameter('sampleRate');
        $aBitRate = AMSUtil::get_http_parameter('aBitRate');

        $dataPath = AMSUtil::get_http_parameter("dataPath");

        if($dataPath == "" )
        {
            echo "<script>window.location.href = '/error.php?mesg=无效的dataPath,请参考e:/data'</script>";
            return ;
        }

        if(strpos($dataPath,"\\"))
        {
            $dataPath = str_replace("\\","/",$dataPath);
        }
        
        if(strrpos($dataPath,"/") == (strlen($dataPath)-1))//去掉结尾/
        {
            echo "<script>window.location.href = '/error.php?mesg=无效的dataPath,请参考e:/data'</script>";
            return ;
        }


        if(!is_dir($dataPath))
        {
            echo "<script>window.location.href = '/error.php?mesg=添加频道失败,dataPath,不存在!'</script>";
            return ;
        }

        $live = new LiveChannelInfo();

        $live->appName = $appName;
        $live->name = $liveName;
        $live->alias = $alias;
        $live->push = AMSUtil::convert_str2_bool($isPush);
        $live->lazyPull = AMSUtil::convert_str2_bool($lazyPull);
        $live->recordAppend = AMSUtil::convert_str2_bool($recordAppend);
        $live->right = intval($right);
        $live->recordEnabled = AMSUtil::convert_str2_bool($recordEnabled) ;
        $live->recordType = intval($recordType);
        $live->flvKeyframe = intval($flvKeyframe);
        $live->liveProperty = intval($liveProperty);
        $live->outputMode = intval($outputMode);
        $live->timeToApend = intval($appendTime);
        $live->intervalTime = intval($intervalTime);
        $live->dataPath = $dataPath;
        $live->format = $format;
        $live->enableHLS = AMSUtil::convert_str2_bool($enableHLS);
        $live->enableTS = AMSUtil::convert_str2_bool($enableTS);
        $live->tsAddress = $tsAddress;

        if($right == 3)//回播
        {
            $live->playback = true;
            $live->keepPlaybackDays = intval($keepPlaybackDays);
            $live->format = "flv";
        }

        /**
         * 拉流
         */
        $pullStreamInfo = new PullStreamInfo();
        $pullStreamInfo->url = $url;

        $pullStreamInfo->vTransfer = AMSUtil::convert_str2_bool($vTransfer);
        $pullStreamInfo->width = intval($width);
        $pullStreamInfo->height = intval($height);
        $pullStreamInfo->frameRate = intval($frameRate);
        $pullStreamInfo->vBitRate = intval($vBitRate);
        $pullStreamInfo->gop = intval($gop);

        $pullStreamInfo->aTransfer = AMSUtil::convert_str2_bool($aTransfer);
        $pullStreamInfo->sampleRate = intval($sampleRate);
        $pullStreamInfo->aBitRate = intval($aBitRate);

        $live->pullStream = $pullStreamInfo;

        $vod_list = $vodClient->getVodsList();
        foreach($vod_list as $vod)
        {
            if($vod->appName == $appName)
            {
                if($vod->dataPath != $dataPath)
                {
                    echo "<script>window.location.href = '/error.php?mesg=添加频道失败,同一直播应用下面dataPath必须一致!'</script>";
                    return ;
                }
            }
        }


        try
        {
            $liveClient->addLive($live);
            $live_vod = new VodsInfo();
            $live_vod->appName = $appName;
            $live_vod->dataPath = $dataPath;
            if(!$vodClient->isExistsVod($appName))
            {
                $vodClient->addVodsForLive($live_vod);
            }
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=添加直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;
    }
    else if($action == "pre_edit")
    {
        $id = AMSUtil::get_http_parameter("id");
        $json = "";
        if($id != "")
        {
            $live = $liveClient->getLiveChannelInfo($id);
            $json = json_encode($live);
        }

        echo $json;
    }

    else if($action == "edit")
    {
        $id = AMSUtil::get_http_parameter("id");
        $appName = AMSUtil::get_http_parameter("appName");
        $liveName = AMSUtil::get_http_parameter("liveName");
        $alias = AMSUtil::get_http_parameter("alias");

        $isPush = AMSUtil::get_http_parameter("isPush");
        $lazyPull  = AMSUtil::get_http_parameter("lazyPull");
        $recordAppend  = AMSUtil::get_http_parameter("recordAppend");
        $right = AMSUtil::get_http_parameter("right");

        $recordEnabled = AMSUtil::get_http_parameter("recordEnabled");
        $recordType = AMSUtil::get_http_parameter("recordType");
        $format = AMSUtil::get_http_parameter("format");

        $enableHLS = AMSUtil::get_http_parameter("enableHLS");
        $enableTS = AMSUtil::get_http_parameter("enableTS");
        $tsAddress = AMSUtil::get_http_parameter("tsAddress");

        $flvKeyframe = AMSUtil::get_http_parameter("flvKeyframe");
        $keepPlaybackDays = AMSUtil::get_http_parameter("keepPlaybackDays");
        $liveProperty = AMSUtil::get_http_parameter("liveProperty");
        $outputMode = AMSUtil::get_http_parameter("outputMode");

        $appendTime = AMSUtil::get_http_parameter("appendTime");
        $intervalTime = AMSUtil::get_http_parameter("intervalTime");

        /*
         * 拉流详情数据
         */
        $url = AMSUtil::get_http_parameter('url');
        $vTransfer = AMSUtil::get_http_parameter('vTransfer');
        $width = AMSUtil::get_http_parameter('width');
        $height = AMSUtil::get_http_parameter('height');
        $frameRate = AMSUtil::get_http_parameter('frameRate');
        $vBitRate = AMSUtil::get_http_parameter('vBitRate');
        $gop = AMSUtil::get_http_parameter('gop');

        $aTransfer = AMSUtil::get_http_parameter('aTransfer');
        $sampleRate = AMSUtil::get_http_parameter('sampleRate');
        $aBitRate = AMSUtil::get_http_parameter('aBitRate');


        $dataPath = AMSUtil::get_http_parameter("dataPath");

        if($dataPath == "" )
        {
            echo "<script>window.location.href = '/error.php?mesg=无效的dataPath,请重试！'</script>";
            return ;
        }

        if(strpos($dataPath,"\\"))
        {
            $dataPath = str_replace("\\","/",$dataPath);
        }

        if(strpos($dataPath,"/") == (strlen($dataPath)-1))//去掉结尾/
        {
            echo "<script>window.location.href = '/error.php?mesg=无效的dataPath,请重试！'</script>";
            return ;
        }


        if(!is_dir($dataPath))
        {
            echo "<script>window.location.href = '/error.php?mesg=添加频道失败,dataPath,不存在!'</script>";
            return ;
        }

        $live = $liveClient->getLiveChannelInfo($id);

        $live->appName = $appName;
        $live->name = $liveName;
        $live->alias = $alias;
        $live->push = AMSUtil::convert_str2_bool($isPush);
        $live->lazyPull = AMSUtil::convert_str2_bool($lazyPull);
        $live->recordAppend = AMSUtil::convert_str2_bool($recordAppend);
        //$live->right = intval($right);forbidden don't allow edit;
        $live->recordEnabled = AMSUtil::convert_str2_bool($recordEnabled) ;
        $live->recordType = intval($recordType);
        $live->flvKeyframe = intval($flvKeyframe);
        $live->liveProperty = intval($liveProperty);
        $live->outputMode = intval($outputMode);
        $live->timeToApend = intval($appendTime);
        $live->intervalTime = intval($intervalTime);
        $live->dataPath = $dataPath;
        $live->format = $format;
        $live->enableHLS = AMSUtil::convert_str2_bool($enableHLS);
        $live->enableTS = AMSUtil::convert_str2_bool($enableTS);
        $live->tsAddress = $tsAddress;

        if($right == 3)//回播
        {
            $live->playback = true;
            $live->keepPlaybackDays = intval($keepPlaybackDays);
            $live->format = "flv";
        }

        /**
         * 拉流
         */
        $pullStreamInfo = new PullStreamInfo();
        $pullStreamInfo->url = $url;

        $pullStreamInfo->vTransfer = AMSUtil::convert_str2_bool($vTransfer);
        $pullStreamInfo->width = intval($width);
        $pullStreamInfo->height = intval($height);
        $pullStreamInfo->frameRate = intval($frameRate);
        $pullStreamInfo->vBitRate = intval($vBitRate);
        $pullStreamInfo->gop = intval($gop);

        $pullStreamInfo->aTransfer = AMSUtil::convert_str2_bool($aTransfer);
        $pullStreamInfo->sampleRate = intval($sampleRate);
        $pullStreamInfo->aBitRate = intval($aBitRate);

        $live->pullStream = $pullStreamInfo;
        $vod_list = $vodClient->getVodsList();
        foreach($vod_list as $vod)
        {
            if($vod->appName == $appName)
            {
                if($vod->dataPath != $dataPath)
                {
                    echo "<script>window.location.href = '/error.php?mesg=编辑频道失败,同一直播应用下面dataPath必须一致!'</script>";
                    return ;
                }
            }
        }


        try
        {
            $liveClient->editLive($live);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;
    }

    else if($action == "del")
    {
        $id = AMSUtil::get_http_parameter("id");
        $appName = AMSUtil::get_http_parameter("appName");
        try
        {
            $liveClient->delLive($id);
            $vod_obj = $vodClient->queryVodByLiveName($appName);
            if(null != $vod_obj)
            {
                if(count($liveClient->getListLiveInfos()) == 0)
                {
                    $vodClient->delVod($vod_obj->id);
                }
            }
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=删除直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/live_list.html'</script>";
        return ;
    }
    else if($action == "furls_list")
    {
        $id = AMSUtil::get_http_parameter("id");
        try
        {
            $live =  $liveClient->getLiveChannelInfo($id);
            $furls = $live->forwardUrls;
            $json = json_encode($furls);
            echo $json;
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=获取转发流列表失败(".$e->getMessage().")'</script>";
            return ;
        }
    }
    else if($action == "edit_furls")
    {
        $id = AMSUtil::get_http_parameter("id");
        $forwardUrls = AMSUtil::get_http_parameter("furls");

        $url_list = array();
        if(is_array($forwardUrls))
        {

           foreach($forwardUrls as $val)
           {
               $forward_url = new LiveForwardUrl();
               $forward_url->url = $val;
               $url_list[]=$forward_url;
           }
        }

        try
        {
            $live = $liveClient->getLiveChannelInfo($id);
            $live->forwardUrls = $url_list;
            $liveClient->editLive($live);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;
    }
    else if($action == "add_substream")
    {
        $id = AMSUtil::get_http_parameter("id");
        $width = AMSUtil::get_http_parameter("width");
        $height = AMSUtil::get_http_parameter("height");

        //视频设置
        $vTransfer = AMSUtil::get_http_parameter("vTransfer");
        $frameRate = AMSUtil::get_http_parameter("frameRate");
        $vBitRate = AMSUtil::get_http_parameter("vBitRate");
        $gop = AMSUtil::get_http_parameter("gop");
        //音频设置
        $aTransfer = AMSUtil::get_http_parameter("aTransfer");
        $sampleRate = AMSUtil::get_http_parameter("sampleRate");
        $aBitRate = AMSUtil::get_http_parameter("aBitRate");

        $outputMode = AMSUtil::get_http_parameter("outputMode");

        $live = $liveClient->getLiveChannelInfo($id);
        $name = "x1";//first substream named x1
        if($live->outputs != null)
        {
            $name = "x".(count($live->outputs)+1);
        }

        $stream = new OutputStreamInfo();
        $stream->name = $name;
        $stream->liveStatus = $liveStatus;

        $stream->width = intval($width);
        $stream->height = intval($height);
        $stream->vTransfer = AMSUtil::convert_str2_bool($vTransfer);
        $stream->frameRate = intval($frameRate);
        $stream->vBitRate = intval($vBitRate);
        $stream->gop = intval($gop);

        $stream->aTransfer = AMSUtil::convert_str2_bool($aTransfer);
        $stream->sampleRate = intval($sampleRate);
        $stream->aBitRate = intval($aBitRate);

        $live->outputs[] = $stream;
        $live->outputMode = intval($outputMode);

        try
        {
            $liveClient->editLive($live);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;
    }

    else if($action == "del_substream")
    {
        $id = AMSUtil::get_http_parameter("id");
        $name = AMSUtil::get_http_parameter("name");

        $live = $liveClient->getLiveChannelInfo($id);
        $sub_stream = $live->outputs;
        $sub_stream_array = array();
        foreach($sub_stream as $val)
        {
            $m_name = $val->name;
            if($m_name != $name)
            {
                $sub_stream_array[] = $val;
            }
        }

        $live->outputs = $sub_stream_array;
        try
        {
            $liveClient->editLive($live);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/live_list.html'</script>";
        return ;
    }
    else if($action == "live_replace")
    {
        $id = AMSUtil::get_http_parameter("id");
        $start_time = AMSUtil::get_http_parameter("startTime");
        $end_time = AMSUtil::get_http_parameter("endTime");
        $flv = AMSUtil::get_http_parameter("flv");

        $replace_list = array();
        if(is_array($start_time) && is_array($end_time) && is_array($flv))
        {
            for($i=0;$i<count($start_time);$i++)
            {
                $replace = new ReplaceFlvInfo();
                $replace->startTime = $start_time[$i];
                $replace->endTime =  $end_time[$i];
                $replace->flv = $flv[$i];
                $replace_list[] = $replace;
            }
        }

        try
        {
            $live = $liveClient->getLiveChannelInfo($id);
            $live->replaces = $replace_list;
            $liveClient->editLive($live);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;
    }
    else if($action == "live_replace_list")
    {
        $id = AMSUtil::get_http_parameter("id");

        $live = $liveClient->getLiveChannelInfo($id);
        $live_replace = $live->replaces;
        $json = json_encode($live_replace);
        echo $json;
    }
    else if($action == "live_while_play_list")
    {
        $id = AMSUtil::get_http_parameter("id");
        $live_while_play_list = $playItemService->getItems($id);
        $json = json_encode($live_while_play_list);
        echo $json;
    }
    else if($action == "live_while_play")
    {
        $id = AMSUtil::get_http_parameter("id");
        $scheduled_time = AMSUtil::get_http_parameter("scheduledTime");
        $duration = AMSUtil::get_http_parameter("duration");
        $flv = AMSUtil::get_http_parameter("flv");

        $while_play_list = array();
        if(is_array($scheduled_time) && is_array($duration) && is_array($flv))
        {
            for($i=0;$i<count($scheduled_time);$i++)
            {
                $item = new PlayItem();
                $item->type = 0;
                $item->scheduledTime = intval($scheduled_time[$i]);
                $item->duration = intval($duration[$i]);
                $item->value = $flv[$i];

                $while_play_list[] = $item;
            }
        }

        try
        {
            $live = $playItemService->editPlayItemLive($while_play_list,$id);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;

    }
    else if($action == "rtmp_play_url")
    {
        $id = AMSUtil::get_http_parameter("id");
        $live = $liveClient->getLiveChannelInfo($id);
        $ip = ServerStartUpConfig::getInstance()->ip;
        $port = ServerStartUpConfig::getInstance()->port;
        $play_url = "rtmp://".$ip.":".$port."/".$live->appName."/".$live->name;
        echo $play_url;
    }
    else if($action == "live_guid_play")
    {
        $id = AMSUtil::get_http_parameter("id");
        $live = $liveClient->getLiveChannelInfo($id);

        $item_list = $playItemService->getItems($id);
        foreach($item_list as $item)
        {
            $type = $item->type;
            if($type == 1)//live value当中存放的就是播放视频地址
            {
                $m_live = $liveClient->getLiveChannelInfo($item->value);
                $ip = ServerStartUpConfig::getInstance()->ip;
                $port = ServerStartUpConfig::getInstance()->port;
                $play_url = "rtmp://".$ip.":".$port."/".$m_live->appName."/".$m_live->name;
                $item->value = $play_url;
            }
            else //vod play url is rtmp
            {
                $path = $item->value;
                $base_dir = $live->dataPath."/";
                $live_name_path = str_replace($base_dir,"",$path);

                $ip = ServerStartUpConfig::getInstance()->ip;
                $port = ServerStartUpConfig::getInstance()->port;
                $play_url = "rtmp://".$ip.":".$port."/".$live->appName."/".$live_name_path;
                $item->value = $play_url;
            }
        }

        $json = json_encode($item_list);
        echo $json;

    }
    else if($action == "add_live_guid_play")
    {
        $id = AMSUtil::get_http_parameter("id");
        //if type is vod
        $flv = AMSUtil::get_http_parameter("flv");
        $duration = AMSUtil::get_http_parameter("duration");

        //if tyep is live
        $appName = AMSUtil::get_http_parameter("appName");
        $liveName = AMSUtil::get_http_parameter("liveName");
        $type = AMSUtil::get_http_parameter("type");

        $item_list = $playItemService->getItems($id);
        if(intval($type) == 1)//live
        {
            $paly_item_id = 0;
            $live_list = $liveClient->getListLiveInfos();
            foreach($live_list as $live)
            {
                if($live->appName == $appName && $live->name == $liveName)
                {
                    $play_item_id = $live->id;
                    break;
                }
            }
            if($play_item_id != 0)
            {
                $item = new PlayItem();
                $item->type = 1;
                $item->value = strval($play_item_id);
                $item_list[] = $item;
            }
            else
            {
                echo "<script>window.location.href = '/error.php?mesg=不存在此直播频道,请核实后再操作!'</script>";
                return ;
            }

        }
        else if(intval($type) == 0)//vod
        {
            $item = new PlayItem();
            $item->type = 0;
            $item->value = $flv;
            $item->duration = -1;
            $item_list[] = $item;
        }

        try
        {
            $playItemService->editPlayItemLive($item_list,$id);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=编辑直播频道失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;

    }
    else if($action == "del_live_guid_play")
    {
        $id = AMSUtil::get_http_parameter("id");
        $itemIndex = AMSUtil::get_http_parameter("itemIndex");
        try
        {
            $playItemService->delPlayItemLive($id,intval($itemIndex));
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=删除导播列表失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/live_guid_play.html?id=$id'</script>";
        return ;
    }
    /**
     * ajax swap guide play
     */
    else if($action == "swap_guid_play")
    {
        $id = AMSUtil::get_http_parameter("id");
        $itemIndex = intval(AMSUtil::get_http_parameter("itemIndex"));
        $mesg = "ok";
        try
        {
            $item_list = $playItemService->getItems($id);
            $item = $item_list[$itemIndex];
            array_splice($item_list,$itemIndex,1);//remove this item
            array_unshift($item_list,$item);//add the item to front in this array

             $playItemService->editPlayItemLive($item_list,$id);
        }
        catch(Exception $e)
        {
            $mesg = $e->getMessage();
        }
        echo $mesg;
    }
    else if($action == "start_record")
    {
        $id = AMSUtil::get_http_parameter("id");
        $live = $liveClient->getLiveChannelInfo($id);

        if(!$live->liveStatus || !$live->recordEnabled)
        {
            echo "<script>window.location.href = '/error.php?mesg=开启录像失败,当前频道未直播或录像功能未启用!'</script>";
            return ;
        }
        /**
         *liveProperty 为1时候，允许推流，不允许发布，不允许录像   为3时候，不允许推流，不允许发布，不允许录像
         *录像 正在直播时 && 录像可用时
         */
        if($live->liveProperty == 1 || $live->liveProperty == 3)
        {
            echo "<script>window.location.href = '/error.php?mesg=开启录像失败,当前频道liveProperty属性不允许录像!'</script>";
            return ;
        }

        $record_file ="[".$live->appName."_".$live->name."]_".date("YmdHis");
        try
        {
            $liveClient->startRecord($live->appName,$live->name,$record_file);
        }
        catch (Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=开启录像失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/live_list.html'</script>";
        return ;

    }
    else if($action == "stop_record")
    {
        $id = AMSUtil::get_http_parameter("id");
        $live = $liveClient->getLiveChannelInfo($id);

        try
        {
            $liveClient->stopRecord($live->appName,$live->name);
        }
        catch (Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=停止录像失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/live_list.html'</script>";
        return ;

    }
    else if($action == "pro_status")
    {
        $id = AMSUtil::get_http_parameter("id");
        $type = AMSUtil::get_http_parameter("type");
        $status = AMSUtil::get_http_parameter("status");

        if($type == "hls")
        {
            if($status == "open")
            {
                try
                {
                    $live = $liveClient->getLiveChannelInfo($id);
                    $liveClient->startHLS($live->appName,$live->name);
                }
                catch (Exception $e)
                {
                    echo "<script>window.location.href = '/error.php?mesg=HLS开启失败(".$e->getMessage().")'</script>";
                    return ;
                }

                echo "<script>window.location.href = '/live_list.html'</script>";
                return ;
            }
            else if($status == "close")
            {
                try
                {
                    $live = $liveClient->getLiveChannelInfo($id);
                    $liveClient->stopHLS($live->appName,$live->name);
                }
                catch (Exception $e)
                {
                    echo "<script>window.location.href = '/error.php?mesg=HLS关闭失败(".$e->getMessage().")'</script>";
                    return ;
                }
                echo "<script>window.location.href = '/live_list.html'</script>";
                return ;
            }

        }
        else if($type == "ts")
        {
            if($status == "open")
            {
                try
                {
                    $live = $liveClient->getLiveChannelInfo($id);
                    $liveClient->startTS($live->appName,$live->name);
                }
                catch (Exception $e)
                {
                    echo "<script>window.location.href = '/error.php?mesg=TS开启失败(".$e->getMessage().")'</script>";
                    return ;
                }

                echo "<script>window.location.href = '/live_list.html'</script>";
                return ;
            }
            else if($status == "close")
            {
                try
                {
                    $live = $liveClient->getLiveChannelInfo($id);
                    $liveClient->stopTS($live->appName,$live->name);
                }
                catch (Exception $e)
                {
                    echo "<script>window.location.href = '/error.php?mesg=TS关闭失败(".$e->getMessage().")'</script>";
                    return ;
                }
                echo "<script>window.location.href = '/live_list.html'</script>";
                return ;
            }
        }

    }

    else if($action == "edit_publish")
    {
        $id = AMSUtil::get_http_parameter("id");
        $liveProperty = AMSUtil::get_http_parameter("liveProperty");

        $live = $liveClient->getLiveChannelInfo($id);
        $live->liveProperty = intval($liveProperty);

        try
        {
            $liveClient->editLive($live);
        }
        catch (Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=修改liveProperty属性失败(".$e->getMessage().")'</script>";
            return ;
        }
        echo "<script>window.location.href = '/live_list.html'</script>";
        return ;
    }



    else if($action == "refresh_stream")
    {
        $bitRates = $liveClient->getBitRates();
        echo $bitRates;
    }
    else if($action == "license")
    {
        $license = $serverService->getLicenseInfo();
        $json = json_encode($license);
        echo $json;
    }
    else if($action == "ip_port")
    {
        $ip = ServerStartUpConfig::getInstance()->ip;
        $port = ServerStartUpConfig::getInstance()->port;
        $obj = array();
        $obj["ip"] = $ip;
        $obj["port"] = $port;
        echo json_encode($obj);
    }
    else if($action == "hls_webpath")
    {
        $hls_webpath = ServerStartUpConfig::getInstance()->hls_web_path;
        echo $hls_webpath;
    }

    else
    {

    }






