<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/DiskMediaService.php";
    require_once "handle/util/AMSUtil.php";

    $diskService = new DiskMediaService();
    $action = AMSUtil::get_http_parameter("action");
    $dialog = AMSUtil::get_http_parameter("dialog");
    
    if($action == "live_medias_list")
    {
        $list = $diskService->get_whole_live_medias();
        $json = json_encode($list);
        echo $json;
    }
    else if($action == "live_medias_list_choose")
    {
        $startTime = AMSUtil::get_http_parameter("startTime");
        $endTime = AMSUtil::get_http_parameter("endTime");
        $appName = AMSUtil::get_http_parameter("appName");
        $key = AMSUtil::get_http_parameter("key");

        $media_list = array(); //final return list
        //choose media by appName
        if($appName != "")
        {
            $media_list = $diskService->get_whole_medias_by_appname($appName);
        }
        else
        {
            $media_list = $diskService->get_whole_live_medias();
        }

        //choose media by start time
        if($startTime != "")
        {
            $startTime = substr($startTime,0,strpos($startTime," ")+1)."00:00:00";
            for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $create_time = $media->create_time;
                if($startTime != "")//compare start time
                {
                    if(strtotime($create_time) < strtotime($startTime))
                    {
                        array_splice($media_list,$i,1);
                    }
                }
            }
        }

        //choose media by end time
        if($endTime != "")
        {
            $endTime = substr($endTime,0,strpos($endTime," ")+1)."23:59:59";

             for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $create_time = $media->create_time;
                if($endTime != "")//compare end time
                {
                    if(strtotime($create_time) > strtotime($endTime))
                    {
                        array_splice($media_list,$i,1);
                    }
                }
            }
        }

        //choose media by key
        if($key != "")
        {
            for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $media_name = $media->name;
                $index = strpos($media_name,$key);
                if($index === false)
                    $index = -1;
                if($index != -1 || $media_name==$key)
                {
                    $red_fname = str_replace($key,"<font color='#990000'>$key</font>",$media_name);
                    $media_list[$i]->name = $red_fname;
                }
                else
                {
                    array_splice($media_list,$i,1);
                }
            }
        }

        $json = json_encode($media_list);
        echo $json;
    }
    else if($action == "vod_medias_list")
    {
        $list = $diskService->get_whole_vod_medias();
        $json = json_encode($list);
        echo $json;
    }
    else if($action == "vod_medias_list_choose")
    {
        $startTime = AMSUtil::get_http_parameter("startTime");
        $endTime = AMSUtil::get_http_parameter("endTime");
        $appName = AMSUtil::get_http_parameter("appName");
        $key = AMSUtil::get_http_parameter("key");

        $media_list = array(); //final return list
        //choose media by appName
        if($appName != "")
        {
            $media_list = $diskService->get_whole_medias_by_appname($appName);
        }
        else
        {
            $media_list = $diskService->get_whole_vod_medias();
        }

        //choose media by start time
        if($startTime != "")
        {
            $startTime = substr($startTime,0,strpos($startTime," ")+1)."00:00:00";
            for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $create_time = $media->create_time;
                if($startTime != "")//compare start time
                {
                    if(strtotime($create_time) < strtotime($startTime))
                    {
                        array_splice($media_list,$i,1);
                    }
                }
            }
        }

        //choose media by end time
        if($endTime != "")
        {
            $endTime = substr($endTime,0,strpos($endTime," ")+1)."23:59:59";

            for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $create_time = $media->create_time;
                if($endTime != "")//compare end time
                {
                    if(strtotime($create_time) > strtotime($endTime))
                    {
                        array_splice($media_list,$i,1);
                    }
                }
            }
        }

        //choose media by key
        if($key != "")
        {
            for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $media_name = $media->name;
                $index = strpos($media_name,$key);
                if($index === false)
                    $index = -1;
                if($index != -1 || $media_name==$key)
                {
                    $red_fname = str_replace($key,"<font color='#990000'>$key</font>",$media_name);
                    $media_list[$i]->name = $red_fname;
                }
                else
                {
                    array_splice($media_list,$i,1);
                }
            }
        }

        $json = json_encode($media_list);
        echo $json;
    }






