<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/LiveClientService.php";
    require_once "handle/service/LiveRecordTimeService.php";
    require_once "handle/service/ServerStartUpService.php";
    require_once "handle/util/AMSUtil.php";


    $liveClient = new LiveClientService();
    $recordService = new LiveRecordTimeService();

    $action = AMSUtil::get_http_parameter("action");
    $dialog = AMSUtil::get_http_parameter("dialog");
    
    if($action == "list")
    {
        $id = AMSUtil::get_http_parameter("id");//liveId
        $json = "";
        $list = $recordService->getRecordListByLiveId($id);
        $recordService->initRecordStatus($list);
        $json = json_encode($list);
        echo $json;
    }
    else if($action == "add")
    {
        $id = AMSUtil::get_http_parameter("id");//liveId
        $name = AMSUtil::get_http_parameter("name");
        $startTime = AMSUtil::get_http_parameter("startTime");
        $endTime = AMSUtil::get_http_parameter("endTime");
        $daysOfWeek = AMSUtil::get_http_parameter("daysOfWeek");


        $time_map_array = array();
        $live_record_info_array = array();

        if(is_array($startTime) && is_array($endTime) && is_array($daysOfWeek))
        {
            for($i=0;$i<count($startTime);$i++)
            {
                $m_start_time = $startTime[$i];
                $m_end_time = $endTime[$i];
                $m_days_of_week = $daysOfWeek[$i];
                $m_name = $name[$i];

                $live_record_info = new LiveRecordInfo();
                $live_record_info->liveId = intval($id);
                $live_record_info->name = $m_name;
                $live_record_info->startTime = $m_start_time;
                $live_record_info->endTime = $m_end_time;
                $live_record_info->daysOfWeek = $m_days_of_week;

                $live_record_info_array[] = $live_record_info;
                $time_map_array[$m_start_time] = $m_end_time;
            }
        }

        $validate_time = $recordService->isIllegalRecordTime($time_map_array);
        if(!$validate_time)
        {
            echo "<script>window.location.href = '/error.php?mesg=开始时间与结束时间格式不正确,请核实!'</script>";
            return ;
        }

        $xml = $recordService->saveLiveRecordIntoXML($live_record_info_array,intval($id));
        $liveClient->sendRecordXML($xml);

        echo "<script>window.location.href = '/live_record_time.html?id=".$id."'</script>";
        return ;
    }

