<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/RegisterEncoderService.php";
    require_once "handle/util/AMSUtil.php";

    $encoderService = new RegisterEncoderService();

    $action = AMSUtil::get_http_parameter("action");
    $dialog = AMSUtil::get_http_parameter("dialog");
    
    if($action == "scan_list_json")
    {
        $list = $encoderService->getRegisterList();
        $json = json_encode($list);
        echo $json;
    }
    else if($action == "get_encoder")
    {
        $mesg = "";
        $mac = AMSUtil::get_http_parameter("mac_addr");
        $list = $encoderService->getRegisterList();
        foreach($list as $val)
        {
            if($val->mac_addr == $mac)
            {
                $mesg = json_encode($val);
                break;
            }
        }

        echo $mesg;
    }
    else if($action == "modify_ip")
    {
        $mac_addr = AMSUtil::get_http_parameter("mac_addr");
        $ip_addr = AMSUtil::get_http_parameter("ip_addr");
        $ip_mask = AMSUtil::get_http_parameter("ip_mask");
        $ip_gateway = AMSUtil::get_http_parameter("ip_gateway");
        $username = AMSUtil::get_http_parameter("username");
        $pass = AMSUtil::get_http_parameter("pass");
        
        $register_encoder = new RegisterEncoder();
        $register_encoder->mac_addr = $mac_addr;
        $register_encoder->ip_addr = $ip_addr;
        $register_encoder->ip_mask = $ip_mask;
        $register_encoder->ip_gateway = $ip_gateway;
        $register_encoder->username = $username;
        $register_encoder->pass = $pass;

        $flag = $encoderService->modifyIp($register_encoder);
        if(intval($flag) == -1)
        {
            echo "<script>window.location.href = '/error.php?mesg=修改IP失败,用户名或密码不正确!'</script>";
            return ;
        }

        echo "<script>window.location.href = '/encoder_list.html'</script>";
        return ;
    }


