<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/LiveClientService.php";
    require_once "handle/service/ServerStartUpService.php";
    require_once "handle/util/AMSUtil.php";

    $liveClient = new LiveClientService();
    $server = new ServerStartUpService();

    $action = AMSUtil::get_http_parameter("action");
    $dialog = AMSUtil::get_http_parameter("dialog");
    
    if($action == "get")
    {
        $startup = $server->getServerStartUp();
        $json = json_encode($startup);
        echo $json;
    }
    else if($action == "set")
    {
        $port = AMSUtil::get_http_parameter("port");
        $rtsp_port = AMSUtil::get_http_parameter("rtsp_port");
        $rtmp_threadPoolSize = AMSUtil::get_http_parameter("rtmp_threadPoolSize");
        $rtmp_maxSocket = AMSUtil::get_http_parameter("rtmp_maxSocket");
        $rtsp_threadPoolSize = AMSUtil::get_http_parameter("rtsp_threadPoolSize");
        $rtsp_maxSocket = AMSUtil::get_http_parameter("rtsp_maxSocket");
        $receiveMessageSize = AMSUtil::get_http_parameter("receiveMessageSize");
        $receiveBufferSize = AMSUtil::get_http_parameter("receiveBufferSize");
        $sendBufferSize = AMSUtil::get_http_parameter("sendBufferSize");

        $server_startup = new ServerStartUp();
        $server_startup->port = intval($port);
        $server_startup->rtsp_port = intval($rtsp_port);
        $server_startup->rtmp_threadPoolSize = intval($rtmp_threadPoolSize);
        $server_startup->rtmp_maxSocket = intval($rtmp_maxSocket);
        $server_startup->rtsp_threadPoolSize = intval($rtsp_threadPoolSize);
        $server_startup->rtsp_maxSocket = intval($rtsp_maxSocket);
        $server_startup->receiveMessageSize = intval($receiveMessageSize);
        $server_startup->receiveBufferSize = intval($receiveBufferSize);
        $server_startup->sendBufferSize = intval($sendBufferSize);
        $mesg = "ok";
        try
        {
            $server->setServerStartUp($server_startup);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=AMS参数设置失败(".$e->getMessage().")'</script>";
            return ;
        }
        echo "<script>window.location.href = '/server_startup.html'</script>";
        return ;
    }
    else if($action == "licinfo_get")
    {
        $licinfo = $server->getLicenseInfo();
        $json = json_encode($licinfo);
        echo $json;
    }
    else if($action == "runtime")
    {
        $sererRuntTime = $server->getServerStartTime();
        echo $sererRuntTime;
    }


