<?php
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
    require_once(dirname(__FILE__) . '/../../global.php');
    require_once "handle/service/LiveClientService.php";
    require_once "handle/service/VodsClientService.php";
    require_once "handle/util/AMSUtil.php";

    $liveClient = new LiveClientService();
    $vodClient = new VodsClientService();

    $action = AMSUtil::get_http_parameter("action");
    $dialog = AMSUtil::get_http_parameter("dialog");
    
    if($action == "list")
    {
        $list = $vodClient->getVodsList();
        $liveList = $liveClient->getListLiveInfos();
        foreach($list as $vod)
        {
            $flag = false;
            foreach($liveList as $live)
            {
                if($live->appName == $vod->appName)
                {
                    $flag = true;
                }
            }
            if(!$flag)
            {
                $vod->vodType = 1;//自定义的媒体点播路径
            }
        }

        $json = json_encode($list);
        echo $json;
    }
    else if($action == "list_json")
    {
        $list = $vodClient->getVodsList();
        $liveList = $liveClient->getListLiveInfos();
        foreach($list as $vod)
        {
            $flag = false;
            foreach($liveList as $live)
            {
                if($live->appName == $vod->appName)
                {
                    $flag = true;
                }
            }
            if(!$flag)
            {
                $vod->vodType = 1;//自定义的媒体点播路径
            }
        }

        $json = json_encode($list);
        echo $json;
    }

    else if($action == "add")
    {
        $appName = AMSUtil::get_http_parameter("appName");
        $dataPath = AMSUtil::get_http_parameter("dataPath");

        if($dataPath == "" )
        {
            echo "<script>window.location.href = '/error.php?mesg=无效的dataPath,请参考e:/data'</script>";
            return ;
        }

        if(strpos($dataPath,"\\"))
        {
            $dataPath = str_replace("\\","/",$dataPath);
        }

        if(strrpos($dataPath,"/") == (strlen($dataPath)-1))//去掉结尾/
        {
            echo "<script>window.location.href = '/error.php?mesg=无效的dataPath,请参考e:/data'</script>";
            return ;
        }


        if(!is_dir($dataPath))
        {
            echo "<script>window.location.href = '/error.php?mesg=添加失败,dataPath,不存在!'</script>";
            return ;
        }

        $vod = new VodsInfo();
        $vod->appName = $appName;
        $vod->dataPath = $dataPath;

        try
        {
            $liveList = $liveClient->getListLiveInfos();
            foreach($liveList as $live)
            {
                if($live->appName == $appName)
                {
                    echo "<script>window.location.href = '/error.php?mesg=此应用名称己经存在,请重试！'</script>";
                    return ;
                }
            }

            $vodClient->addVodsForLive($vod);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=添加点播目录失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/tips.php?dialog=".$dialog."'</script>";
        return ;
    }
    else if($action == "del")
    {
        $appName = AMSUtil::get_http_parameter("appName");

        try
        {
            $vod = $vodClient->queryVodByLiveName($appName);
            $vodClient->delVod($vod->id);
        }
        catch(Exception $e)
        {
            echo "<script>window.location.href = '/error.php?mesg=删除点播目录失败(".$e->getMessage().")'</script>";
            return ;
        }

        echo "<script>window.location.href = '/vod_list.html'</script>";
        return ;
    }



