<?php

require_once "PlayItem.php";
require_once "LiveForwardUrl.php";
require_once "OutputStreamInfo.php";
require_once "ReplaceFlvInfo.php";
require_once "PullStreamInfo.php";
/**
 * Class LiveChannelInfo此类用作直播频道的传输数据
 */
class LiveChannelInfo
{
    /**
     * 流ID
     */
    public $id = 0;
    /**
     * 直播流名,具体点播的流名称 比如 appName/liveName -- live/live1
     */
    public $name = "";
    /**
     * 直播应用名称, 比如 appName/liveName -- live/live1
     */
    public $appName = "";
    /**
     * 别名
     */
    public $alias = "";
    /**
     * 流创建时间
     */
    public $createdDate = "";
    /**
     * 录像文件存放的路径
     */
    public $dataPath = "";

    /**
     * 直播状态
     */
    public $liveStatus = false;

    /**
     * 流发布状态
     */
    public $publishStatus = false;
    /**
     * 是否可录像
     */
    public $recordEnabled = false;
    /**
     * 录像状态
     */
    public $recordStatus = false;
    /**
     *0 手动 1 定时 2 一有流就开始录制
     */
    public $recordType = 0;
    /**
     * @var用作AMS的频道类型
     * right == 1 || right == 0普通直播
     * right == 3 回播模式
     * right == 4 轮播模式
     * right == 5 导播模式
     */
    public $right = 1;
    /**
     * @var boolean类型值,是否要开启HLS
     */
    public $enableHLS = false;
    /**
     * @var boolean类型值,是否要开启TS
     */
    public $enableTS = false;
    /**
     * @var TS地址
     */
    public $tsAddress = "";
    /**
     * @var string 录制文件的格式 flv mp4
     */
    public $format = "flv";
    /**
     * @var boolean类型值 ts现在的开启状态
     */
    public $tsStatus = false;
    /**
     * @var boolean类型值 HLS现在的开启状态
     */
    public $hlsStatus = false;
    /**
     * @var 当拉流时是false, 正常频道为true
     */
    public $push = true;
    /**
     * @var true时， 表示有客户端接入时才拉， 否则立刻启动拉流
     */
    public $lazyPull = false;
    /**
     * @var true时表示，录像时，采用追加方式，否则新生成一个文件。
     */
    public $recordAppend = false;

    /**
     * 1、flvKeyFrame="0"：录制的同时不生成索引信息，录制结束后也不会对文件进行处理；
     * 2、flvKeyFrame="1"：录制的同时生成节目点播用到的，索引信息，视频解码信息，音频解码信息等，当在我们点播平台中使用时候，可以直接点播，无需再生成这些信息；
     * 3、flvKeyFrame="2"：录制的同时不生成索引信息，但录制结束后会重新把索引信息添加到文件头部；方便别的点播平台引用。
     */
    public $flvKeyframe = 1;
    /**
     * 是否启用回播
     */
    public $playback = false;
    /**
     * 回播天数设置
     */
    public $keepPlaybackDays = 7;

    /**
     *  为0，则允许推流，允许发布出去，允许录像；
    为1时候，允许推流，不允许发布，不允许录像；
    为2时候，允许推流，不允许发布，允许录像；
    为3时候，不允许推流，不允许发布，不允许录像
     */
    public $liveProperty = 0;
    /**
     * 推流的IP地址
     */
    public $ip = "";
    /**
     * 推流设备的类型
     * 0  编码器
     * 1   拉流
     * 2 转码子流
     * 3 playList(插播）
     */
    public $type = 0;
    /**
     * 子码流模式  0推模式 1 拉模式
     */
    public $outputMode = 0;
    /**
     * 录像文件间隔多久后分段 单位是分
     */
    public $intervalTime = 0;
    /**
     * 录像文件断流多久内追加  单位是秒
     */
    public $timeToApend = 0;


    /**
     * @var拉流详情
     */
    public $pullStream;

    /**
     * 轮播Item列表
     * @var array
     */
    public $items = array();
    /**
     * 转发流列表
     * @var array
     */
    public $forwardUrls = array();
    /**
     * @var array
     * 子码流
     */
    public $outputs = array();
    /**
     * @var array
     * 插播
     */
    public $replaces = array();


    /**
     * 将liveChannelInfo对象序列化为JSON
     * @return string
     */
    public function toJson()
    {
        return json_encode($this);
    }

    /**
     * 从一个JSON对象当中解析为LiveChannelInfo对象
     * @param $json
     */
    public function fromJson($json_obj)
    {
        $this->id = $json_obj['id'];
        $this->name = $json_obj['name'];
        $this->appName = $json_obj['appName'];
        $this->alias = $json_obj['alias'];
        $this->createdDate = $json_obj['createdDate'];
        $this->dataPath = $json_obj["dataPath"];
        $this->liveStatus = $json_obj["liveStatus"];
        $this->publishStatus = $json_obj["publishStatus"];
        $this->recordEnabled = $json_obj["recordEnabled"];
        $this->recordStatus = $json_obj["recordStatus"];
        $this->recordType = $json_obj["recordType"];
        $this->right = $json_obj["right"];
        $this->enableHLS = $json_obj["enableHLS"];
        $this->enableTS = $json_obj["enableTS"];
        $this->tsAddress = $json_obj["tsAddress"];
        $this->format = $json_obj["format"];
        $this->tsStatus = $json_obj["tsStatus"];
        $this->hlsStatus = $json_obj["hlsStatus"];
        $this->push = $json_obj["push"];
        $this->lazyPull = $json_obj["lazyPull"];
        $this->recordAppend = $json_obj["recordAppend"];
        $this->flvKeyframe = $json_obj["flvKeyframe"];
        $this->playback = $json_obj["playback"];
        $this->keepPlaybackDays = $json_obj["keepPlaybackDays"];
        $this->liveProperty = $json_obj["liveProperty"];
        $this->ip = $json_obj["ip"];
        $this->type = $json_obj["type"];
        $this->outputMode = $json_obj["outputMode"];
        $this->intervalTime = $json_obj["intervalTime"];
        $this->timeToApend = $json_obj["timeToApend"];


        //解析拉流信息
        $pullStreamInfo = new PullStreamInfo();
        $pullStreamInfo->fromJson($json_obj["pullStream"]);
        $this->pullStream = $pullStreamInfo;

        //解析PlayItem列表
        $json_playItem_array = array();
        $json_playItem = $json_obj["items"];
        for($i=0;$i<count($json_playItem);$i++)
        {
            $playitem = new PlayItem();
            $playitem->fromJson($json_playItem[$i]);
            $json_playItem_array[] = $playitem;
        }
        $this->items = $json_playItem_array;

        //解析转发流列表
        $json_forwardurl_array = array();
        $json_forwardurl = $json_obj["forwardUrls"];
        for($i=0;$i<count($json_forwardurl);$i++)
        {
            $forwardurl = new LiveForwardUrl();
            $forwardurl->fromJson($json_forwardurl[$i]);
            $json_forwardurl_array[] = $forwardurl;
        }
        $this->forwardUrls = $json_forwardurl_array;

        //解析子码流列表
        $json_outputs_array = array();
        $json_outputs = $json_obj["outputs"];
        for($i=0;$i<count($json_outputs);$i++)
        {
            $outputs = new OutputStreamInfo();
            $outputs->fromJson($json_outputs[$i]);
            $json_outputs_array[] = $outputs;
        }
        $this->outputs = $json_outputs_array;

        //解析插播列表
        $json_replaceflv_array = array();
        $json_replaceflv = $json_obj["replaces"];
        for($i=0;$i<count($json_replaceflv);$i++)
        {
            $replaceflv = new ReplaceFlvInfo();
            $replaceflv->fromJson($json_replaceflv[$i]);
            $json_replaceflv_array[] = $replaceflv;
        }
        $this->replaces = $json_replaceflv_array;

    }

    /**
     * 从一个JSON数组当中序列化为一个包含LiveChannelInfo对象的array数组
     * @param $json_array
     */
    public static function fromJsonList($json_array)
    {
        $liveChannelInfo_array = array();
        $array_count = count($json_array);
        for($i = 0;$i<$array_count;$i++)
        {
            $liveChannelInfo = new LiveChannelInfo();
            $liveChannelInfo->fromJson($json_array[$i]);
            $liveChannelInfo_array[] = $liveChannelInfo;
        }
        return $liveChannelInfo_array;
    }


    public function main_test()
    {
        $liveChannelInfo = new LiveChannelInfo();
        $liveChannelInfo->id = 1;
        $liveChannelInfo->name = "live";
        $liveChannelInfo->appName = "live1";

        $data = $liveChannelInfo->toJson();
        echo $data;
    }


}


//$LiveChannelInfo = new LiveChannelInfo();
//$LiveChannelInfo->main_test();