<?php

class LiveConnectionInfo
{
    /** 标识 */
    public $id = "";

    /** ip地址 */
    public $ip = "";

    /** 开始连接时间 */
    public $startTime = "";

    /** 连接类型  1 编码器  2客户端*/
    public $type = 1;

    /**
     * 从一个JSON对象当中解析为LiveConnectionInfo对象
     * @param $json
     */
    public function fromJson($json_obj)
    {
        $this->id = $json_obj['id'];
        $this->ip = $json_obj['ip'];
        $this->startTime = $json_obj['startTime'];
        $this->type = $json_obj['type'];
    }

    /**
     * 从一个JSON数组当中序列化为一个包含LiveConnectionInfo对象的array数组
     * @param $json_array
     */
    public static function fromJsonList($json_array)
    {
        $liveConnection_array = array();
        $array_count = count($json_array);
        for($i = 0;$i<$array_count;$i++)
        {
            $liveConnection = new LiveConnectionInfo();
            $liveConnection->fromJson($json_array[$i]);
            $liveConnection_array[] = $liveConnection;
        }
        return $liveConnection_array;
    }
}