<?php

/**
 * Class PlayItem此类是用来进行轮播,导播时传输数据使用
 */
class PlayItem
{
    /**
     * 播放清单的内容，如果是直播流则是 直播流对应的id,如果是文件，则是文件名
     */
    public $value = "";
    /**
     *  1表示直播流  0 表示flv文件
     */
    public $type = 0;
    /**
     * 如果没有播放持续时间，则赋值为-1， 否则给出秒数
     */
    public $duration =-1 ;
    /**
     * 如果不是定时播放，则赋值为-1， 否则给出从凌晨0点开始的秒数 （不支持具体某一天的某个时间，否则只能启动一次）
     */
    public $scheduledTime = -1;
    /**
     * 持续播放时间格式化后的时间如 00:00:00
     */
    public $formatDuration = "";
    /**
     * 定时播放时间格式化后的时间如 00:00:00
     */
    public $formatScheduleTime = "";

    /**
     * 将liveChannelInfo对象序列化为JSON
     * @return string
     */
    public function toJson()
    {
        return json_encode($this);
    }

    /**
     * 从一个JSON对象当中解析为LiveChannelInfo对象
     * @param $json
     */
    public function fromJson($json_obj)
    {
        $this->value = $json_obj['value'];
        $this->type = $json_obj['type'];
        $this->duration = $json_obj['duration'];
        $this->scheduledTime = $json_obj['scheduledTime'];
    }

}