<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/bean/Admin.php";

/**
 * Class AdminService
 * 针对管理员的一些操作,如验证登陆还有修改密码等
 */
class AdminService
{
    public function getAdmin()
    {
        $xml_path = __DIR__."'/../config/ams_server.xml";
        $doc = new DOMDocument();
        $doc->load($xml_path);

        $admin_node = $doc->getElementsByTagName("admin");

        $uname = $admin_node->item(0)->getAttribute("uname");
        $pwd = $admin_node->item(0)->getAttribute("pwd");

        $admin = new Admin();
        $admin->uname = $uname;
        $admin->pwd = $pwd;

        return $admin;
    }

    public function check_admin($uname,$pwd)
    {
        $admin = $this->getAdmin();
        if($admin->uname == $uname && $admin->pwd == $pwd)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function modify_pwd($uname,$pwd,$new_pwd)
    {
        $flag = $this->check_admin($uname,$pwd);
        if($flag)
        {
            $this->write_xml_pwd($new_pwd);
            return true;
        }
        return false;
    }

    private function write_xml_pwd($pwd)
    {
        $xml_path = __DIR__."'/../config/ams_server.xml";
        $doc = new DOMDocument();
        $doc->formatOutput = true;
        $doc->load($xml_path);

        $admin_node = $doc->getElementsByTagName("admin");
        $admin_node->item(0)->setAttribute("pwd",$pwd);

        $doc->save($xml_path);
    }
}
//$admin_service = new AdminService();
//$admin_service->write_xml_pwd("333");
?>


