<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/bean/DiskMedia.php";
require_once "LiveClientService.php";
require_once "VodsClientService.php";
require_once "ServerStartUpService.php";

/**
 * Class DiskMediaService
 * 此类用来获取指定直播频道 dataPath下面的所有的点播视频
 */
class DiskMediaService
{

    public function get_whole_medias($liveId)
    {
        $liveClient = new LiveClientService();
        $live = $liveClient->getLiveChannelInfo($liveId);
        $data_path = $live->dataPath;

        $disk_medias = $this->scan_disk_medias($data_path);
        foreach($disk_medias as $media)
        {
            $path = $media->path;
            $base_dir = $live->dataPath."/";
            $live_name_path = str_replace($base_dir,"",$path);

            $ip = ServerStartUpConfig::getInstance()->ip;
            $port = ServerStartUpConfig::getInstance()->port;
            $http_port = ServerStartUpConfig::getInstance()->http_port;

            $rtmp_play_url = "rtmp://".$ip.":".$port."/".$live->appName."/".$live_name_path;
            $http_play_url = "http://".$ip.":".$http_port."/".$live->appName."/".$live_name_path;
            $rtmp_play_url_ckplayer = "rtmp://".$ip.":".$port."/".$live->appName."|".$live_name_path;

            $media->rtmp_play_url = $rtmp_play_url;
            $media->http_play_url = $http_play_url;
            $media->rtmp_play_url_ckplayer = $rtmp_play_url_ckplayer;
        }

        //对数组当中的DiskMedia对象按照创建时间进行从大到小的排序
        usort($disk_medias,function($a,$b)
        {
            $a_create_time = $a->create_time;
            $b_create_time = $b->create_time;

            if(strtotime($a_create_time) > strtotime($b_create_time))
            {
                return -1;
            }
            else if(strtotime($a_create_time) < strtotime($b_create_time))
            {
                return 1;
            }
            else
            {
                return 0;
            }

        });

        return $disk_medias;
    }

    /**
     * 通过点播目录当中的应用名称来查询其下的所有的点播媒体
     * @param $appName
     * @return array
     */
    public function get_whole_medias_by_appname($appName)
    {
        $vodClient = new VodsClientService();
        $vod = $vodClient->queryVodByLiveName($appName);
        $data_path = $vod->dataPath;

        $disk_medias = $this->scan_disk_medias($data_path);

        foreach($disk_medias as $media)
        {
            $path = $media->path;
            $base_dir = $vod->dataPath."/";
            $live_name_path = str_replace($base_dir,"",$path);

            $ip = ServerStartUpConfig::getInstance()->ip;
            $port = ServerStartUpConfig::getInstance()->port;
            $http_port = ServerStartUpConfig::getInstance()->http_port;

            $rtmp_play_url = "rtmp://".$ip.":".$port."/".$vod->appName."/".$live_name_path;
            $http_play_url = "http://".$ip.":".$http_port."/".$vod->appName."/".$live_name_path;
            $rtmp_play_url_ckplayer = "rtmp://".$ip.":".$port."/".$vod->appName."|".$live_name_path;

            $media->rtmp_play_url = $rtmp_play_url;
            $media->http_play_url = $http_play_url;
            $media->rtmp_play_url_ckplayer = $rtmp_play_url_ckplayer;
        }

        //对数组当中的DiskMedia对象按照创建时间进行从大到小的排序
        usort($disk_medias,function($a,$b)
        {
            $a_create_time = $a->create_time;
            $b_create_time = $b->create_time;

            if(strtotime($a_create_time) > strtotime($b_create_time))
            {
                return -1;
            }
            else if(strtotime($a_create_time) < strtotime($b_create_time))
            {
                return 1;
            }
            else
            {
                return 0;
            }

        });

        return $disk_medias;
    }


    /**
     * 扫描出所有点播应用目录下面的FLV视频
     * @return array
     */
    public function get_whole_vod_medias()
    {
        $liveClient = new LiveClientService();
        $vodClient = new VodsClientService();

        $vod_array = array();
        $live_list = $liveClient->getListLiveInfos();
        $vod_list = $vodClient->getVodsList();
        foreach($vod_list as $vod)
        {
            $flag = false;
            foreach($live_list as $live)
            {
                if($live->appName == $vod->appName)
                {
                    $flag = true;
                }
            }
            if(!$flag)
            {
                $vod_array[$vod->appName] = $vod->dataPath;
            }
        }

        $vod_array = array_unique($vod_array);
        $disk_medias = array();
        foreach($vod_array as $appName=> $dataPath)
        {
            $media_list = $this->scan_disk_medias($dataPath);
            foreach($media_list as $media)
            {
                $path = $media->path;
                $base_dir = $dataPath."/";
                $live_name_path = str_replace($base_dir,"",$path);

                $ip = ServerStartUpConfig::getInstance()->ip;
                $port = ServerStartUpConfig::getInstance()->port;
                $http_port = ServerStartUpConfig::getInstance()->http_port;

                $rtmp_play_url = "rtmp://".$ip.":".$port."/".$appName."/".$live_name_path;
                $http_play_url = "http://".$ip.":".$http_port."/".$appName."/".$live_name_path;
                $rtmp_play_url_ckplayer = "rtmp://".$ip.":".$port."/".$appName."|".$live_name_path;

                $media->rtmp_play_url = $rtmp_play_url;
                $media->http_play_url = $http_play_url;
                $media->rtmp_play_url_ckplayer = $rtmp_play_url_ckplayer;
            }

            $disk_medias = array_merge($disk_medias,$media_list);
        }

        //对数组当中的DiskMedia对象按照创建时间进行从大到小的排序
        usort($disk_medias,function($a,$b)
        {
            $a_create_time = $a->create_time;
            $b_create_time = $b->create_time;

            if(strtotime($a_create_time) > strtotime($b_create_time))
            {
                return -1;
            }
            else if(strtotime($a_create_time) < strtotime($b_create_time))
            {
                return 1;
            }
            else
            {
                return 0;
            }

        });

        return $disk_medias;
    }

    /**
     * 获取所有的直播频道中的录播媒体
     * @return array
     */
    public function get_whole_live_medias()
    {
        $liveClient = new LiveClientService();

        $data_path_array = array();
        $live_list = $liveClient->getListLiveInfos();
        foreach($live_list as $live)
        {
            $data_path_array[$live->id] = $live->dataPath;
        }

        $data_path_array = array_unique($data_path_array);
        $disk_medias = array();
        foreach($data_path_array as $key=> $data_path)
        {
            $live = $liveClient->getLiveChannelInfo($key);
            $media_list = $this->scan_disk_medias($data_path);
            foreach($media_list as $media)
            {
                $path = $media->path;
                $base_dir = $data_path."/";
                $live_name_path = str_replace($base_dir,"",$path);

                $ip = ServerStartUpConfig::getInstance()->ip;
                $port = ServerStartUpConfig::getInstance()->port;
                $http_port = ServerStartUpConfig::getInstance()->http_port;

                $rtmp_play_url = "rtmp://".$ip.":".$port."/".$live->appName."/".$live_name_path;
                $http_play_url = "http://".$ip.":".$http_port."/".$live->appName."/".$live_name_path;
                $rtmp_play_url_ckplayer = "rtmp://".$ip.":".$port."/".$live->appName."|".$live_name_path;

                $media->rtmp_play_url = $rtmp_play_url;
                $media->http_play_url = $http_play_url;
                $media->rtmp_play_url_ckplayer = $rtmp_play_url_ckplayer;
            }

            $disk_medias = array_merge($disk_medias,$media_list);
        }

        //对数组当中的DiskMedia对象按照创建时间进行从大到小的排序
        usort($disk_medias,function($a,$b)
        {
            $a_create_time = $a->create_time;
            $b_create_time = $b->create_time;

            if(strtotime($a_create_time) > strtotime($b_create_time))
            {
                return -1;
            }
            else if(strtotime($a_create_time) < strtotime($b_create_time))
            {
                return 1;
            }
            else
            {
                return 0;
            }

        });

        return $disk_medias;
    }


    /**
     * 迭代扫描指定目录下面的所有的FLV文件  MP4文件
     * @param $path
     * @return array
     */
    private function scan_disk_medias($path)
    {
        $tree = array();
        foreach(glob($path.'/*') as $single)
        {
            if(is_dir($single))
            {
                $tree = array_merge($tree,$this->scan_disk_medias($single));
            }
            else
            {
                if($this->endWith($single,"flv") || $this->endWith($single,"FLV") || $this->endWith($single,"mp4") || $this->endWith($single,"MP4"))
                {
                    $disk_media = new DiskMedia();
                    //$disk_media->liveId = intval($liveid);
                    $disk_media->name = iconv('gb2312','utf-8',$this->get_basename($single)) ;
                    $disk_media->size = $this->sizecount(filesize($single));
                    $disk_media->create_time = date("Y-m-d H:i:s",filemtime($single));
                    $disk_media->path = iconv('gb2312','utf-8',$single);
                    $tree[] = $disk_media;
                }
            }
        }

        //对数组当中的DiskMedia对象按照创建时间进行从大到小的排序
        usort($tree,function($a,$b){

            $a_create_time = $a->create_time;
            $b_create_time = $b->create_time;

            if(strtotime($a_create_time) > strtotime($b_create_time))
            {
                return -1;
            }
            else if(strtotime($a_create_time) < strtotime($b_create_time))
            {
                return 1;
            }
            else
            {
                return 0;
            }

        });

        return $tree;
    }




    /**
     * 第一个是原串,第二个是 部份串
     * @param $haystack
     * @param $needle
     * @return bool
     */
    private function endWith($haystack, $needle)
    {
        $length = strlen($needle);
        if($length == 0)
        {
            return true;
        }
        return (substr($haystack, -$length) === $needle);
    }

    private function sizecount($filesize)
    {
        if($filesize >= 1073741824)
        {
            $filesize = round($filesize / 1073741824 * 100) / 100 . 'gb';
        } elseif($filesize >= 1048576)
        {
            $filesize = round($filesize / 1048576 * 100) / 100 . 'mb';
        } elseif($filesize >= 1024)
        {
            $filesize = round($filesize / 1024 * 100) / 100 . 'kb';
        } else
        {
            $filesize = $filesize . 'bytes';
        }
        return $filesize;
    }

    function get_basename($filename){
        return preg_replace('/^.+[\\\\\\/]/', '', $filename);
    }

    public function main_test()
    {
     // $media_list = $this->get_whole_medias("2");
        //$media_list = $this->get_whole_live_medias();


        $media_list = $this->scan_disk_medias("e:/virweb");

        $startTime = "2015-07-00 00:00:00";
        $endTime = "2015-10-23 23:59:59";
        $appName = "";
        $key = "a";

        //choose media by start time
        for($i=(count($media_list)-1);$i>=0;$i--)
        {
            $media = $media_list[$i];
            $create_time = $media->create_time;
            if($startTime != "")//compare start time
            {
                if(strtotime($create_time) < strtotime($startTime))
                {
                    array_splice($media_list,$i,1);
                }
            }
        }

        //choose media by end time
        for($i=(count($media_list)-1);$i>=0;$i--)
        {
            $media = $media_list[$i];
            $create_time = $media->create_time;
            if($endTime != "")//compare end time
            {
                if(strtotime($create_time) > strtotime($endTime))
                {
                    array_splice($media_list,$i,1);
                }
            }
        }

        //choose media by key
        if($key != "")
        {
            for($i=(count($media_list)-1);$i>=0;$i--)
            {
                $media = $media_list[$i];
                $media_name = $media->name;
                $index = strpos($media_name,$key);
                if($index === false)
                    $index = -1;
                if($index != -1 || $media_name==$key)
                {
                    $red_fname = str_replace($key,"<font color='#990000'>$key</font>",$media_name);
                    $media_list[$i]->name = $red_fname;
                }
                else
                {
                    array_splice($media_list,$i,1);
                }
            }
        }


        foreach($media_list as $val)
        {
           echo "file_name:".$val->name."<br>";
           echo "file_size:".$val->size."<br>";
           echo "file_create_time:".$val->create_time."<br>";
           echo "file_path:".$val->path."<br>";
           echo "==============================================<br>";
        }

    }

}

//$service = new DiskMediaService();
//$service->main_test();


?>