<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/net/ClientSentCommand.php";
require_once "handle/bean/LiveChannelInfo.php";
require_once "handle/bean/LiveInfo.php";
require_once "ServerStartUpConfig.php";
require_once "WebException.php";

/**
 * Class LiveClientService此类用作向AMS通讯发送各种命令和接收数据使用,
 * 发送socket数据时使用ClientSendCommand类来完成
 */
class LiveClientService
{
    /**
     * 服务器端IP
     */
    private  $mServerIp;
    /**
     * 服务器端口号
     */
    private $mServerPort;
    /**
     * 通讯密匙
     */
    private $key = "";

    public function __construct()
    {
        $this->mServerIp = ServerStartUpConfig::getInstance()->ip;
        $this->mServerPort = ServerStartUpConfig::getInstance()->adminPort;
        $this->key = ServerStartUpConfig::getInstance()->key;
    }

    /**
     *  得到AMS服务器的 直播列表 把JSON格式转换成 对象集合
     */
    public function getListLiveInfos()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("ListLiveInfos","");
        $json_array = json_decode($recv_json,true);
        $liveChannelInfo_array = LiveChannelInfo::fromJsonList($json_array);

        return $liveChannelInfo_array;
    }

    public function getListLiveInfosByType($type)
    {
        $list = $this->getListLiveInfos();
        $list_temp = array();
        foreach($list as $obj)
        {
            $m_type = $obj->right;
            if($m_type == $type)
            {
                $list_temp[] = $obj;
            }
        }

        return $list_temp;
    }

    /**
     * 通过直播频道的ID值来上获取一个直播频道
     * @param $liveId
     */
    public function getLiveChannelInfo($liveId)
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("GetLiveChannelInfo",strval($liveId));
        $json_array = json_decode($recv_json,true);
        $liveChannelInfo = new LiveChannelInfo();
        $liveChannelInfo->fromJson($json_array);
        return $liveChannelInfo;
    }

    /**
     * 检测是否存在直播频道
     * @param $appName
     * @param $liveName
     * @return bool
     */
    public function isExistsLive($appName, $liveName)
    {
        $status = false;
        $lives = $this->getListLiveInfos();

        for($i=0;$i<count($lives);$i++)
        {

            if ($lives[$i]->appName == $appName && $lives[$i]->name == $liveName)
            {
                $status = true;
                break;
            }
        }

        return $status;
    }

    /**
     * AMS开始录像
     * @param $appName
     * @param $liveName
     * @param $recordFile
     */
    public function startRecord($appName, $liveName, $recordFile)
    {
        $live = new LiveInfo();
        $live->appName = $appName;
        $live->name = $liveName;
        $live->recordFile = $recordFile;

        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("StartRecord",$sentJson);

    }

    /**
     * AMS停止录像
     * @param $appName
     * @param $liveName
     */
    public function stopRecord($appName, $liveName)
    {
        $live = new LiveInfo();
        $live->appName = $appName;
        $live->name = $liveName;

        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);

        $recv_json = $command->sendCommand("StopRecord",$sentJson);

    }

    /**
     * 开启HLS
     * @param $appName
     * @param $liveName
     */
    public function startHLS($appName, $liveName)
    {
        $live = new LiveInfo();
        $live->appName = $appName;
        $live->name = $liveName;

        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("StartHLS",$sentJson);
    }

    public function stopHLS($appName, $liveName)
    {
        $live = new LiveInfo();
        $live->appName = $appName;
        $live->name = $liveName;

        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("StopHLS",$sentJson);
    }

    public function startTS($appName, $liveName)
    {
        $live = new LiveInfo();
        $live->appName = $appName;
        $live->name = $liveName;

        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("StartTS",$sentJson);
    }

    public function stopTS($appName, $liveName)
    {
        $live = new LiveInfo();
        $live->appName = $appName;
        $live->name = $liveName;

        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("StopTS",$sentJson);
    }

    /**
     * 获取bitrate
     * @param $liveId
     * @return string
     */
    public function getBitRate($liveId)
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $bitrate = $command->sendCommand("GetBitRate",strval($liveId));
        return $bitrate;
    }

    /**
     * 获取所有直播频道的比特率
     * @return string
     */
    public function getBitRates()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $bitrates = $command->sendCommand("GetBitRates","");
        return $bitrates;
    }

    public function addLive($LiveChannelInfo)
    {
        $status = false;
        $sentJson = json_encode($LiveChannelInfo);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);

        // 添加之前判断直播频道是否己经存在
        $flag = $this->isExistsLive($LiveChannelInfo->appName, $LiveChannelInfo->name);
        if ($flag == true)
        {
            throw new WebException("the live already exist!");
        }
        else
        {
            $json = $command->sendCommand("AddLive", $sentJson);
            if ("ok" == $json)
            {
                $status = true;
            }
        }
        return $status;
    }

    public function editLive($LiveChannelInfo)
    {
        $status = false;
        $sentJson = json_encode($LiveChannelInfo);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);

        $json = $command->sendCommand("EditLive", $sentJson);
        if ("ok" == $json)
        {
            $status = true;
        }

        return $status;
    }

    public function delLive($liveId)
    {
        $status = false;

        $live = new LiveChannelInfo();
        $live->id = intval($liveId);
        $sentJson = json_encode($live);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $json = $command->sendCommand("DelLive", $sentJson);
        if ("ok" == $json)
        {
            $status = true;
        }

        return $status;
    }

    /**
     * 将定时录像文件发送给AMS,AMS会按此定时任务去执行录像
     * @param $recordXML
     * @return bool
     */
    public function sendRecordXML($recordXML)
    {
        $status = false;
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $json = $command->sendCommand("UploadRecordXml", $recordXML);
        if ("ok" == $json)
        {
            $status = true;
        }

        return $status;
    }


    public function main_test()
    {
        /*
        echo "<br>===================//test get liveChannelInfoList======================<br/>";
        //test get liveChannelInfoList
        $list = $this->getListLiveInfos();
        echo json_encode($list);

        echo "<br>================= //test get liveChannelInfo by id========================<br/>";
        //test get liveChannelInfo by id
        $liveChannelInfo = $this->getLiveChannelInfo("4");
        echo json_encode($liveChannelInfo);

        echo "<br>================= //test isExistsLive========================<br/>";
        //test isExistsLive
        $flag = $this->isExistsLive("live","live1");
        echo "flag:".$flag;

        echo "<br>================= //test startRecord========================<br/>";
        //test startRecord
        $this->startRecord("live","live1","aaa");
        */
       // $this->getListLiveInfosByType(1);

    }

}

//$service = new LiveClientService();
//$service->main_test();


?>