<?php
require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/net/ClientSentCommand.php";
require_once "handle/bean/LiveConnectionInfo.php";
require_once "ServerStartUpConfig.php";

/**
 * Class LiveConnectionService
 * 获取在线用户包括编码器与客户端
 */
class LiveConnectionService
{
    /**
     * 服务器端IP
     */
    private  $mServerIp;
    /**
     * 服务器端口号
     */
    private $mServerPort;
    /**
     * 通讯密匙
     */
    private $key = "";

    public function __construct()
    {
        $this->mServerIp = ServerStartUpConfig::getInstance()->ip;
        $this->mServerPort = ServerStartUpConfig::getInstance()->adminPort;
        $this->key = ServerStartUpConfig::getInstance()->key;
    }

    /**
     * 获取直播在线人数
     * @return mixed
     */
    public function getLiveConnections()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("GetConnectionInfos","");
        $json_array = json_decode($recv_json,true);
        $livConnections_array = LiveConnectionInfo::fromJsonList($json_array);
        return $livConnections_array;
    }

    public function main_test()
    {
        $list = $this->getLiveConnections();
        echo json_encode($list);
    }
}