<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/bean/LiveRecordInfo.php";
require_once "handle/service/LiveClientService.php";


/**
 * 此类用来操作 record.xml
 */
class LiveRecordTimeService
{
    /**
     * 初使化RecordInfo对象当中的录像状态
     * @param $record_info_list
     */
    public function initRecordStatus($record_info_list)
    {
        if(is_array($record_info_list))
        {
            $liveClient = new LiveClientService();
            foreach($record_info_list as $vsl)
            {
                $liveId = $vsl->liveId;
                $live = $liveClient->getLiveChannelInfo($liveId);
                $live_status = $live->liveStatus;
                $record_status = $live->recordStatus;
                if($live_status && $record_status)//正在直播,正在录制
                {
                    $curAfterBeginTime = $this->isAfterBeginTime($vsl);
					$curBeforeEndTime = $this->isBeforeEndTime($vsl);
                    if($curAfterBeginTime && $curBeforeEndTime)
                    {
                        $vsl->recordStatus = true;
                    }
                }
            }
        }
    }

    /**
     * 当前时间是否在开始时间之后
     * @param $record_info_obj
     * @return bool
     */
    public function isAfterBeginTime($record_info_obj)
    {
        $now_time = date("H:i:s");
        $now_week = strval(date("w"));
        if($now_week == "0")//周日
            $now_week == "7";

        $end_time = $record_info_obj->startTime;
        $week = $record_info_obj->daysOfWeek;

        if(strpos($week,$now_week))//时间为当前的星期
        {
            if(strtotime($now_time) > strtotime($end_time))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        return false;
    }

    /**
     * 当前时间是否在结束时间之前
     * @param $record_info_obj
     * @return bool
     */
    public function isBeforeEndTime($record_info_obj)
    {
        $now_time = date("H:i:s");
        $now_week = strval(date("w"));
        if($now_week == "0")//周日
            $now_week == "7";

        $end_time = $record_info_obj->endTime;
        $week = $record_info_obj->daysOfWeek;

        if(strpos($week,$now_week))//时间为当前的星期
        {
            if(strtotime($now_time) < strtotime($end_time))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        return false;
    }

    /**
     * 验证开始录像时间与结束时间格式是否符合标准
     * @param $record_time_map_array
     * 传入的是一个key-value的数组
     * @return bool
     */
    public function isIllegalRecordTime($record_time_map_array)
    {
        if(!is_array($record_time_map_array))
            return false;

        $end_time_array = array_keys($record_time_map_array);
        $end_time_array = array_values($record_time_map_array);
        $pattern = '/[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/';
        /**
         * 验证开始时间是否合法
         */
        foreach($end_time_array as $val)
        {
            $match_count = preg_match($pattern,$val,$matches);
            if($match_count == 0 || ($matches[0] != $val))
            {
               return false;
            }
        }
        /**
         * 验证结束时间是否合法
         */
        foreach($end_time_array as $val)
        {
            $match_count = preg_match($pattern,$val,$matches);
            if($match_count == 0 || ($matches[0] != $val))
            {
                return false;
            }
        }
        return true;
    }

    /**
     * 获取指定live_id的数据
     * @param $live_id
     * @return array
     */
   public function getRecordListByLiveId($live_id)
   {
        $xml_path = __DIR__."'/../config/record.xml";
        $doc = new DOMDocument();
        $doc->load($xml_path);

        $record_nodes = $doc->getElementsByTagName("record");
        $live_record_list = array();
        foreach($record_nodes as $val)
        {
           $id = $val->getAttribute("id");
           $liveId = $val->getAttribute("liveId");
           $name = $val->getAttribute("name");
           $startTime = $val->getAttribute("startTime");
           $endTime = $val->getAttribute("endTime");
           $daysOfWeek = $val->getAttribute("daysOfWeek");

            if($liveId == $live_id)
            {
                $live_record = new LiveRecordInfo();
                $live_record->id = intval($id);
                $live_record->liveId = intval($liveId);
                $live_record->name = $name;
                $live_record->startTime = $startTime;
                $live_record->endTime = $endTime;
                $live_record->daysOfWeek = $daysOfWeek;
                $live_record_list[] = $live_record;
            }
        }

        return $live_record_list;
   }

    /**
     * 将指定直播频道下面的定时任务保存到XML当中<br>
     * 1.保存的方法为先将本地硬盘上面的XML中的数据读取到内存当中
     * 2.删除本地硬盘上面的XML
     * 3.在内存当中删除liveid为参数$live_id的数据
     * 4.重新生成新的XML 这样做是为了格式化XML
     * @param $live_record_array
     * @param $live_id
     * @return string
     */
   public function saveLiveRecordIntoXML($live_record_array,$live_id)
   {
       $xml_path = __DIR__."'/../config/record.xml";
       $doc = new DOMDocument('1.0','utf-8');
       $doc->formatOutput = true;

       $root = null;
       $record_list = array();
       if(file_exists($xml_path))
       {
           $record_list = $this->getRecordList();//将数据保存在内存当中
           unlink($xml_path);//删除record.xml然后再创建一个新的record.xml为了格式化xml当中的内容
       }

       if(count($record_list) >0)
       {
            for($i=count($record_list)-1;$i>=0;$i--)
            {
                if($record_list[$i]->liveId == (intval($live_id)))
                {
                    array_splice($record_list,$i,1);
                }
            }
       }

       $root = $doc->createElement("records");
       $doc->appendChild($root);


       if(is_array($live_record_array))
       {
           $record_list = array_merge($record_list,$live_record_array);
       }

       /**
        * 创建record节点
        */
       $base_index = 1;
       foreach($record_list as $val)
       {
           $record_node = $doc->createElement("record");
           $record_node->setAttribute("id",$base_index);
           $record_node->setAttribute("liveId",$val->liveId);
           $record_node->setAttribute("name",$val->name);
           $record_node->setAttribute("startTime",$val->startTime);
           $record_node->setAttribute("endTime",$val->endTime);
           $record_node->setAttribute("daysOfWeek",$val->daysOfWeek);
           $record_node->setAttribute("recordName",$val->recordName);
           $root->appendChild($record_node);
           $base_index++;
       }

       $doc->save($xml_path);
       return $doc->saveXML();
   }

    /**
     * 从record.xml当中读取数据并且存放到一个LiveRecordInfo类型的数组当中
     * @return array
     */
    private function getRecordList()
    {
        $xml_path = __DIR__."'/../config/record.xml";
        $doc = new DOMDocument();
        $doc->load($xml_path);

        $record_nodes = $doc->getElementsByTagName("record");
        $live_record_list = array();
        foreach($record_nodes as $val)
        {
            $id = $val->getAttribute("id");
            $liveId = $val->getAttribute("liveId");
            $name = $val->getAttribute("name");
            $startTime = $val->getAttribute("startTime");
            $endTime = $val->getAttribute("endTime");
            $daysOfWeek = $val->getAttribute("daysOfWeek");

            $live_record = new LiveRecordInfo();
            $live_record->id = intval($id);
            $live_record->liveId = intval($liveId);
            $live_record->name = $name;
            $live_record->startTime = $startTime;
            $live_record->endTime = $endTime;
            $live_record->daysOfWeek = $daysOfWeek;
            $live_record_list[] = $live_record;
        }
        return $live_record_list;
    }

    public function main_test()
    {
        /*
        $live_record_array = array();

        $record = new LiveRecordInfo();
        $record->id = 1;
        $record->liveId = 3;l
        $record->name = "cccc";
        $record->startTime = "10:00:00";
        $record->endTime = "18:20:00";
        $record->daysOfWeek = "1,2,3,4,5,6,7";

        $live_record_array[] = $record;
        $live_record_array[] = $record;
        $live_record_array[] = $record;

        $obj = new LiveRecordTimeService();
        //header("Content-Type: text/plain");
        */


        /*

        $check_time = $obj->isAfterBeginTime($record);
        $check_time1 = $obj->isBeforeEndTime($record);
        echo "check_time:".$check_time."<br>";
        echo "check_time:".$check_time1;


        $xml = $obj->saveLiveRecordIntoXML($live_record_array,3);
        echo "xml content:".$xml;



        $record_list = LiveReocrdTimeService::getRecordList("1");
        var_dump($record_list);
        */
    }

}
