<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/net/ClientSentCommand.php";
require_once "handle/bean/PlayItem.php";
require_once "ServerStartUpConfig.php";

class PlayItemService
{
    /**
     * 服务器端IP
     */
    private  $mServerIp;
    /**
     * 服务器端口号
     */
    private $mServerPort;
    /**
     * 通讯密匙
     */
    private $key = "";

    public function __construct()
    {
        $this->mServerIp = ServerStartUpConfig::getInstance()->ip;
        $this->mServerPort = ServerStartUpConfig::getInstance()->adminPort;
        $this->key = ServerStartUpConfig::getInstance()->key;
    }

    public function getItems($liveId)
    {
        $liveClient = new LiveClientService();
        $live = $liveClient->getLiveChannelInfo($liveId);
        $while_play_list = $live->items;
        return $while_play_list;
    }

    public function editPlayItemLive($play_item_list,$liveId)
    {
        $status = false;
        $json_array = array();
        $json_array['id'] = intval($liveId);
        $json_array['items'] = $play_item_list;

        $json = json_encode($json_array);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("EditPlayItemsLive",$json);

        if ("ok" == $recv_json)
        {
            $status = true;
        }

        return $status;
    }

    public function delPlayItemLive($liveId,$itemIndex)
    {
        $items_list = $this->getItems($liveId);
        array_splice($items_list,$itemIndex,1);
        $this->editPlayItemLive($items_list,$liveId);
    }


    public function main_test()
    {


    }

}



?>