<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/net/ClientSentCommand.php";
require_once "handle/bean/ServerStartUp.php";
require_once "handle/bean/RegisterEncoder.php";
require_once "ServerStartUpConfig.php";

class RegisterEncoderService
{
    /**
     * 服务器端IP
     */
    private  $mServerIp;
    /**
     * 服务器端口号
     */
    private $mServerPort;
    /**
     * 通讯密匙
     */
    private $key = "";

    public function __construct()
    {
        $this->mServerIp = ServerStartUpConfig::getInstance()->ip;
        $this->mServerPort = ServerStartUpConfig::getInstance()->adminPort;
        $this->key = ServerStartUpConfig::getInstance()->key;
    }


    public function getRegisterList()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("ScanEncoders","");
        $json_array = json_decode($recv_json,true);
        $register_encoder_array = RegisterEncoder::fromJsonList($json_array);
        return $register_encoder_array;
    }

    public function modifyIp($register_obj)
    {
        $json = json_encode($register_obj);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("ModifyIp",$json);
        return intval($recv_json);
    }

}