<?php

/**
 * Class ServerStartUpConfig
 * 单例模式,加载ams_server.xml中的配置文件
 */
class ServerStartUpConfig
{
    /**
     * rtmp端口号
     */
    public  $port = 1935;

    public $http_port = 9002;

    public $hls_web_path = "http://127.0.0.1:9001/";

    /**
     * 管理端口号
     */
    public $adminPort = 1936;

    public $ip = "127.0.0.1";
    /**
     * 与AMS通讯的密匙
     */
    public $key = "";

    private static $_instance = null;

    private function __construct()
    {
    }
    private function __clone()
    {
    }
    public static function getInstance()
    {
        if(! (self::$_instance instanceof self) )
        {
            self::$_instance = new self();
            self::init(self::$_instance);
        }

        return self::$_instance;
    }

    private static function init($instance)
    {
        $xml_path = __DIR__."'/../config/ams_server.xml";
        $doc = new DOMDocument();
        $doc->load($xml_path);

        $ams_node = $doc->getElementsByTagName("ams");

        $ams_attr_ip = $ams_node->item(0)->getAttribute("ip");
        $ams_attr_rtmp_port = $ams_node->item(0)->getAttribute("rtmp_port");
        $ams_attr_http_port = $ams_node->item(0)->getAttribute("http_port");
        $ams_attr_hls_web_path = $ams_node->item(0)->getAttribute("hls_web_path");
        $ams_attr_key = $ams_node->item(0)->getAttribute("key");

        $instance->ip = $ams_attr_ip;
        $instance->port = intval($ams_attr_rtmp_port);
        $instance->http_port = intval($ams_attr_http_port);
        $instance->hls_web_path = $ams_attr_hls_web_path;
        $instance->adminPort = (intval($ams_attr_rtmp_port)+1);
        $instance->key = $ams_attr_key;

    }

    public function main_test()
    {
        echo ServerStartUpConfig::getInstance()->ip;
        echo ServerStartUpConfig::getInstance()->port;
        echo ServerStartUpConfig::getInstance()->adminPort;
        echo ServerStartUpConfig::getInstance()->key;
    }



}
//ServerStartUpConfig::getInstance()->main_test();