<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/net/ClientSentCommand.php";
require_once "handle/bean/ServerStartUp.php";
require_once "handle/bean/LicenseInfo.php";
require_once "ServerStartUpConfig.php";


/**
 * Class ServerStartUpService
 * AMS启动时的一些设置参数,还提供了获取AMS的授权信息
 */
class ServerStartUpService
{
    /**
     * 服务器端IP
     */
    private  $mServerIp;
    /**
     * 服务器端口号
     */
    private $mServerPort;
    /**
     * 通讯密匙
     */
    private $key = "";

    public function __construct()
    {
        $this->mServerIp = ServerStartUpConfig::getInstance()->ip;
        $this->mServerPort = ServerStartUpConfig::getInstance()->adminPort;
        $this->key = ServerStartUpConfig::getInstance()->key;
    }

    /**
     * 获取AMS启动时的一些参数
     * @return ServerStartUp
     */
    public function getServerStartUp()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("GetStartupInfo","");
        $json_obj = json_decode($recv_json,true);
        $serverStartUp  = new ServerStartUp();
        $serverStartUp->fromJson($json_obj);

        return $serverStartUp;
    }

    public function setServerStartUp($ServerStartUp)
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $send_json = json_encode($ServerStartUp);
        $recv_json = $command->sendCommand("SetStartupInfo",$send_json);
    }

    /**
     * @return LicenseInfo
     */
    public function getLicenseInfo()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("GetLicenseInfo","");
        $json_obj = json_decode($recv_json,true);
        $license  = new LicenseInfo();
        $license->fromJson($json_obj);

        return $license;
    }

    public function getServerStartTime()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("GetServerStartTime","");
        return (int)$recv_json;
    }



}