<?php

require_once(dirname(__FILE__) . '/../../global.php');
require_once "handle/net/ClientSentCommand.php";
require_once "handle/bean/VodsInfo.php";
require_once "ServerStartUpConfig.php";
require_once "WebException.php";


class VodsClientService
{
    /**
     * 服务器端IP
     */
    private  $mServerIp;
    /**
     * 服务器端口号
     */
    private $mServerPort;
    /**
     * 通讯密匙
     */
    private $key = "";

    public function __construct()
    {
        $this->mServerIp = ServerStartUpConfig::getInstance()->ip;
        $this->mServerPort = ServerStartUpConfig::getInstance()->adminPort;
        $this->key = ServerStartUpConfig::getInstance()->key;
    }
    public function getVodsList()
    {
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $recv_json = $command->sendCommand("ListVodInfos","");
        $json_array = json_decode($recv_json,true);
        $vod_list_array = VodsInfo::fromJsonList($json_array);
        return $vod_list_array;
    }
    public function isExistsVod($appName)
    {
        $status = false;
        $vodsList = $this->getVodsList();

        foreach ($vodsList as $vod)
        {
            if($vod->appName == $appName)
            {
                $status = true;
                break;
            }
        }
		return $status;
    }
    public function addVodsForLive($vod_obj)
    {
        $status = false;
        $sentJson = json_encode($vod_obj);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);

        $flag = $this->isExistsVod($vod_obj->appName);
        if ($flag == true)
        {
            throw new WebException("the vod app already exist!");
        }
        else
        {
            $json = $command->sendCommand("AddVod", $sentJson);
            if ("ok" == $json)
            {
                $status = true;
            }
        }
        return $status;
    }
    public function queryVodByLiveName($appName)
    {
        $query_vod = null;
        $vodsList = $this->getVodsList();
        foreach ($vodsList as $vod)
        {
            if($vod->appName == $appName)
            {
                $query_vod = $vod;
                break;
            }
        }
        return $query_vod;
    }

    public function delVod($id)
    {
        $status = false;
        $vod = new VodsInfo();
        $vod->id = intval($id);

        $sentJson = json_encode($vod);
        $command = new ClientSentCommand($this->mServerIp,$this->mServerPort,$this->key);
        $json = $command->sendCommand("DelVod", $sentJson);
        if ("ok" == $json)
        {
            $status = true;
        }
        return $status;
    }

    public function main_test()
    {


    }

}



?>